/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.restricted;

import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import java.util.List;

public class JavaExprUtils {
    private JavaExprUtils() {
    }

    public static JavaExpr concatJavaExprs(List<JavaExpr> javaExprs) {
        if (javaExprs.size() == 0) {
            return new JavaExpr("\"\"", String.class, Integer.MAX_VALUE);
        }
        if (javaExprs.size() == 1) {
            return javaExprs.get(0);
        }
        int plusOpPrec = Operator.PLUS.getPrecedence();
        StringBuilder resultSb = new StringBuilder();
        boolean isFirst = true;
        for (JavaExpr javaExpr : javaExprs) {
            boolean needsProtection;
            boolean bl = isFirst ? javaExpr.getPrecedence() < plusOpPrec : (needsProtection = javaExpr.getPrecedence() <= plusOpPrec);
            if (isFirst) {
                isFirst = false;
            } else {
                resultSb.append(" + ");
            }
            if (needsProtection) {
                resultSb.append('(').append(javaExpr.getText()).append(')');
                continue;
            }
            resultSb.append(javaExpr.getText());
        }
        return new JavaExpr(resultSb.toString(), String.class, plusOpPrec);
    }
}

