/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataRefAccessIndexNode;
import com.google.template.soy.exprtree.DataRefAccessKeyNode;
import com.google.template.soy.exprtree.DataRefAccessNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.internal.base.CharEscapers;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.shared.internal.NonpluginFunction;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class TranslateToJavaExprVisitor
extends AbstractReturningExprNodeVisitor<JavaExpr> {
    private final Map<String, SoyJavaSrcFunction> soyJavaSrcFunctionsMap;
    private final Deque<Map<String, JavaExpr>> localVarTranslations;

    @AssistedInject
    TranslateToJavaExprVisitor(Map<String, SoyJavaSrcFunction> soyJavaSrcFunctionsMap, @Assisted Deque<Map<String, JavaExpr>> localVarTranslations) {
        this.soyJavaSrcFunctionsMap = soyJavaSrcFunctionsMap;
        this.localVarTranslations = localVarTranslations;
    }

    @Override
    protected JavaExpr visitExprRootNode(ExprRootNode<?> node) {
        return (JavaExpr)this.visit((ExprNode)node.getChild(0));
    }

    @Override
    protected JavaExpr visitNullNode(NullNode node) {
        return new JavaExpr("com.google.template.soy.data.restricted.NullData.INSTANCE", NullData.class, Integer.MAX_VALUE);
    }

    @Override
    protected JavaExpr visitBooleanNode(BooleanNode node) {
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData(node.toSourceString()));
    }

    @Override
    protected JavaExpr visitIntegerNode(IntegerNode node) {
        return this.convertIntegerResult(JavaCodeUtils.genNewIntegerData(node.toSourceString()));
    }

    @Override
    protected JavaExpr visitFloatNode(FloatNode node) {
        return this.convertFloatResult(JavaCodeUtils.genNewFloatData(node.toSourceString()));
    }

    @Override
    protected JavaExpr visitStringNode(StringNode node) {
        return this.convertStringResult(JavaCodeUtils.genNewStringData('\"' + CharEscapers.javaStringEscaper().escape(node.getValue()) + '\"'));
    }

    @Override
    protected JavaExpr visitListLiteralNode(ListLiteralNode node) {
        return this.convertListResult(JavaCodeUtils.genNewListData(this.buildCommaSepChildrenListHelper(node)));
    }

    @Override
    protected JavaExpr visitMapLiteralNode(MapLiteralNode node) {
        return this.convertMapResult(JavaCodeUtils.genNewMapData(this.buildCommaSepChildrenListHelper(node)));
    }

    private String buildCommaSepChildrenListHelper(ExprNode.ParentExprNode node) {
        StringBuilder resultSb = new StringBuilder();
        boolean isFirst = true;
        for (ExprNode child : node.getChildren()) {
            if (isFirst) {
                isFirst = false;
            } else {
                resultSb.append(", ");
            }
            resultSb.append(((JavaExpr)this.visit(child)).getText());
        }
        return resultSb.toString();
    }

    @Override
    protected JavaExpr visitDataRefNode(DataRefNode node) {
        String refText;
        String nullSafetyPrefix = "";
        String firstKey = node.getFirstKey();
        if (node.isIjDataRef()) {
            refText = TranslateToJavaExprVisitor.genGetDataSingleCallWithKey("this.$$ijData", firstKey);
            if (node.isNullSafeIjDataRef()) {
                nullSafetyPrefix = "(this.$$ijData == null) ? com.google.template.soy.data.restricted.NullData.INSTANCE : ";
            }
        } else {
            JavaExpr translation = this.getLocalVarTranslation(firstKey);
            refText = translation != null ? (translation.getPrecedence() == Integer.MAX_VALUE ? translation.getText() : "(" + translation.getText() + ")") : TranslateToJavaExprVisitor.genGetDataSingleCallWithKey("data", firstKey);
        }
        block5: for (ExprNode child : node.getChildren()) {
            DataRefAccessNode accessNode = (DataRefAccessNode)child;
            if (accessNode.isNullSafe()) {
                nullSafetyPrefix = nullSafetyPrefix + "(! " + JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$isNonnull", refText) + ") ? " + "com.google.template.soy.data.restricted.NullData.INSTANCE" + " : ";
            }
            switch (accessNode.getKind()) {
                case DATA_REF_ACCESS_KEY_NODE: {
                    refText = TranslateToJavaExprVisitor.genGetDataSingleCallWithKey(refText, ((DataRefAccessKeyNode)accessNode).getKey());
                    continue block5;
                }
                case DATA_REF_ACCESS_INDEX_NODE: {
                    refText = TranslateToJavaExprVisitor.genGetDataSingleCallWithKey(refText, Integer.toString(((DataRefAccessIndexNode)accessNode).getIndex()));
                    continue block5;
                }
                case DATA_REF_ACCESS_EXPR_NODE: {
                    JavaExpr keyExpr = (JavaExpr)this.visit(accessNode.getChild(0));
                    refText = TranslateToJavaExprVisitor.genGetDataSingleCallWithKeyExpr(refText, keyExpr);
                    continue block5;
                }
            }
            throw new AssertionError();
        }
        if (nullSafetyPrefix.length() == 0) {
            return new JavaExpr(refText, SoyData.class, Integer.MAX_VALUE);
        }
        return new JavaExpr(nullSafetyPrefix + refText, SoyData.class, Operator.CONDITIONAL.getPrecedence());
    }

    private static String genGetDataSingleCallWithKey(String dataExprText, String key) {
        return JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$getDataSingle", dataExprText, "\"" + CharEscapers.javaStringEscaper().escape(key) + "\"");
    }

    private static String genGetDataSingleCallWithKeyExpr(String dataExprText, JavaExpr keyExpr) {
        return JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$getDataSingle", dataExprText, JavaCodeUtils.genMaybeProtect(keyExpr, Integer.MAX_VALUE) + ".toString()");
    }

    @Override
    protected JavaExpr visitGlobalNode(GlobalNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected JavaExpr visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
        JavaExpr operand = (JavaExpr)this.visit(node.getChild(0));
        String integerComputation = JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genUnaryOp("-", JavaCodeUtils.genIntegerValue(operand)));
        String floatComputation = JavaCodeUtils.genNewFloatData(JavaCodeUtils.genUnaryOp("-", JavaCodeUtils.genFloatValue(operand)));
        if (JavaCodeUtils.isAlwaysInteger(operand)) {
            return this.convertIntegerResult(integerComputation);
        }
        if (JavaCodeUtils.isAlwaysFloat(operand)) {
            return this.convertFloatResult(floatComputation);
        }
        return this.convertNumberResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$negative", JavaCodeUtils.genMaybeCast(operand, NumberData.class)));
    }

    @Override
    protected JavaExpr visitNotOpNode(OperatorNodes.NotOpNode node) {
        JavaExpr operand = (JavaExpr)this.visit(node.getChild(0));
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genUnaryOp("!", JavaCodeUtils.genCoerceBoolean(operand))));
    }

    @Override
    protected JavaExpr visitTimesOpNode(OperatorNodes.TimesOpNode node) {
        return this.visitNumberToNumberBinaryOpHelper(node, "*", "$$times");
    }

    @Override
    protected JavaExpr visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
        JavaExpr operand0 = (JavaExpr)this.visit(node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit(node.getChild(1));
        return this.convertFloatResult(JavaCodeUtils.genNewFloatData(JavaCodeUtils.genBinaryOp("/", JavaCodeUtils.genNumberValue(operand0), JavaCodeUtils.genNumberValue(operand1))));
    }

    @Override
    protected JavaExpr visitModOpNode(OperatorNodes.ModOpNode node) {
        JavaExpr operand0 = (JavaExpr)this.visit(node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit(node.getChild(1));
        return this.convertIntegerResult(JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genBinaryOp("%", JavaCodeUtils.genIntegerValue(operand0), JavaCodeUtils.genIntegerValue(operand1))));
    }

    @Override
    protected JavaExpr visitPlusOpNode(OperatorNodes.PlusOpNode node) {
        JavaExpr operand0 = (JavaExpr)this.visit(node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit(node.getChild(1));
        String stringComputation = JavaCodeUtils.genNewStringData(JavaCodeUtils.genBinaryOp("+", JavaCodeUtils.genCoerceString(operand0), JavaCodeUtils.genCoerceString(operand1)));
        String integerComputation = JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genBinaryOp("+", JavaCodeUtils.genIntegerValue(operand0), JavaCodeUtils.genIntegerValue(operand1)));
        String floatComputation = JavaCodeUtils.genNewFloatData(JavaCodeUtils.genBinaryOp("+", JavaCodeUtils.genNumberValue(operand0), JavaCodeUtils.genNumberValue(operand1)));
        if (JavaCodeUtils.isAlwaysTwoIntegers(operand0, operand1)) {
            return this.convertIntegerResult(integerComputation);
        }
        if (JavaCodeUtils.isAlwaysAtLeastOneString(operand0, operand1)) {
            return this.convertStringResult(stringComputation);
        }
        if (JavaCodeUtils.isAlwaysTwoFloatsOrOneFloatOneInteger(operand0, operand1)) {
            return this.convertFloatResult(floatComputation);
        }
        return this.convertUnknownResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$plus", operand0.getText(), operand1.getText()));
    }

    @Override
    protected JavaExpr visitMinusOpNode(OperatorNodes.MinusOpNode node) {
        return this.visitNumberToNumberBinaryOpHelper(node, "-", "$$minus");
    }

    @Override
    protected JavaExpr visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
        return this.visitNumberToBooleanBinaryOpHelper(node, "<", "$$lessThan");
    }

    @Override
    protected JavaExpr visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
        return this.visitNumberToBooleanBinaryOpHelper(node, ">", "$$greaterThan");
    }

    @Override
    protected JavaExpr visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
        return this.visitNumberToBooleanBinaryOpHelper(node, "<=", "$$lessThanOrEqual");
    }

    @Override
    protected JavaExpr visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
        return this.visitNumberToBooleanBinaryOpHelper(node, ">=", "$$greaterThanOrEqual");
    }

    @Override
    protected JavaExpr visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        JavaExpr operand0 = (JavaExpr)this.visit(node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit(node.getChild(1));
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genMaybeProtect(operand0, Integer.MAX_VALUE) + ".equals(" + operand1.getText() + ")"));
    }

    @Override
    protected JavaExpr visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        JavaExpr operand0 = (JavaExpr)this.visit(node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit(node.getChild(1));
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData("! " + JavaCodeUtils.genMaybeProtect(operand0, Integer.MAX_VALUE) + ".equals(" + operand1.getText() + ")"));
    }

    @Override
    protected JavaExpr visitAndOpNode(OperatorNodes.AndOpNode node) {
        return this.visitBooleanToBooleanBinaryOpHelper(node, "&&");
    }

    @Override
    protected JavaExpr visitOrOpNode(OperatorNodes.OrOpNode node) {
        return this.visitBooleanToBooleanBinaryOpHelper(node, "||");
    }

    @Override
    protected JavaExpr visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        JavaExpr operand0 = (JavaExpr)this.visit(node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit(node.getChild(1));
        JavaExpr operand2 = (JavaExpr)this.visit(node.getChild(2));
        Class<?> type1 = operand1.getType();
        Class<?> type2 = operand2.getType();
        Class<?> resultType = null;
        for (Class<?> type = type1; type != null; type = type.getSuperclass()) {
            if (!type.isAssignableFrom(type2)) continue;
            resultType = type;
            break;
        }
        if (resultType == null) {
            throw new AssertionError();
        }
        return new JavaExpr(JavaCodeUtils.genCoerceBoolean(operand0) + " ? " + JavaCodeUtils.genMaybeProtect(operand1, Operator.CONDITIONAL.getPrecedence() + 1) + " : " + JavaCodeUtils.genMaybeProtect(operand2, Operator.CONDITIONAL.getPrecedence() + 1), resultType, Operator.CONDITIONAL.getPrecedence());
    }

    @Override
    protected JavaExpr visitFunctionNode(FunctionNode node) {
        String fnName = node.getFunctionName();
        int numArgs = node.numChildren();
        NonpluginFunction nonpluginFn = NonpluginFunction.forFunctionName(fnName);
        if (nonpluginFn != null) {
            if (numArgs != nonpluginFn.getNumArgs()) {
                throw SoySyntaxException.createWithoutMetaInfo("Function '" + fnName + "' called with the wrong number of arguments" + " (function call \"" + node.toSourceString() + "\").");
            }
            switch (nonpluginFn) {
                case IS_FIRST: {
                    return this.visitIsFirstFunction(node);
                }
                case IS_LAST: {
                    return this.visitIsLastFunction(node);
                }
                case INDEX: {
                    return this.visitIndexFunction(node);
                }
                case QUOTE_KEYS_IF_JS: {
                    return this.visitMapLiteralNode((MapLiteralNode)node.getChild(0));
                }
            }
            throw new AssertionError();
        }
        SoyJavaSrcFunction fn = this.soyJavaSrcFunctionsMap.get(fnName);
        if (fn != null) {
            if (!fn.getValidArgsSizes().contains(numArgs)) {
                throw SoySyntaxException.createWithoutMetaInfo("Function '" + fnName + "' called with the wrong number of arguments" + " (function call \"" + node.toSourceString() + "\").");
            }
            List<JavaExpr> args = this.visitChildren(node);
            try {
                return fn.computeForJavaSrc(args);
            }
            catch (Exception e) {
                throw SoySyntaxException.createCausedWithoutMetaInfo("Error in function call \"" + node.toSourceString() + "\": " + e.getMessage(), e);
            }
        }
        throw SoySyntaxException.createWithoutMetaInfo("Failed to find SoyJavaSrcFunction with name '" + fnName + "'" + " (function call \"" + node.toSourceString() + "\").");
    }

    private JavaExpr visitIsFirstFunction(FunctionNode node) {
        String varName = ((DataRefNode)node.getChild(0)).getFirstKey();
        return this.getLocalVarTranslation(varName + "__isFirst");
    }

    private JavaExpr visitIsLastFunction(FunctionNode node) {
        String varName = ((DataRefNode)node.getChild(0)).getFirstKey();
        return this.getLocalVarTranslation(varName + "__isLast");
    }

    private JavaExpr visitIndexFunction(FunctionNode node) {
        String varName = ((DataRefNode)node.getChild(0)).getFirstKey();
        return this.getLocalVarTranslation(varName + "__index");
    }

    private JavaExpr convertBooleanResult(String exprText) {
        return new JavaExpr(exprText, BooleanData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertIntegerResult(String exprText) {
        return new JavaExpr(exprText, IntegerData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertFloatResult(String exprText) {
        return new JavaExpr(exprText, FloatData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertNumberResult(String exprText) {
        return new JavaExpr(exprText, NumberData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertStringResult(String exprText) {
        return new JavaExpr(exprText, StringData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertListResult(String exprText) {
        return new JavaExpr(exprText, SoyListData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertMapResult(String exprText) {
        return new JavaExpr(exprText, SoyMapData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertUnknownResult(String exprText) {
        return new JavaExpr(exprText, SoyData.class, Integer.MAX_VALUE);
    }

    private JavaExpr visitBooleanToBooleanBinaryOpHelper(ExprNode.OperatorNode node, String javaOpToken) {
        JavaExpr operand0 = (JavaExpr)this.visit((ExprNode)node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit((ExprNode)node.getChild(1));
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genBinaryOp(javaOpToken, JavaCodeUtils.genCoerceBoolean(operand0), JavaCodeUtils.genCoerceBoolean(operand1))));
    }

    private JavaExpr visitNumberToNumberBinaryOpHelper(ExprNode.OperatorNode node, String javaOpToken, String utilsLibFnName) {
        JavaExpr operand0 = (JavaExpr)this.visit((ExprNode)node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit((ExprNode)node.getChild(1));
        String integerComputation = JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genBinaryOp(javaOpToken, JavaCodeUtils.genIntegerValue(operand0), JavaCodeUtils.genIntegerValue(operand1)));
        String floatComputation = JavaCodeUtils.genNewFloatData(JavaCodeUtils.genBinaryOp(javaOpToken, JavaCodeUtils.genNumberValue(operand0), JavaCodeUtils.genNumberValue(operand1)));
        if (JavaCodeUtils.isAlwaysTwoIntegers(operand0, operand1)) {
            return this.convertIntegerResult(integerComputation);
        }
        if (JavaCodeUtils.isAlwaysAtLeastOneFloat(operand0, operand1)) {
            return this.convertFloatResult(floatComputation);
        }
        return this.convertNumberResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils." + utilsLibFnName, JavaCodeUtils.genMaybeCast(operand0, NumberData.class), JavaCodeUtils.genMaybeCast(operand1, NumberData.class)));
    }

    private JavaExpr visitNumberToBooleanBinaryOpHelper(ExprNode.OperatorNode node, String javaOpToken, String utilsLibFnName) {
        JavaExpr operand0 = (JavaExpr)this.visit((ExprNode)node.getChild(0));
        JavaExpr operand1 = (JavaExpr)this.visit((ExprNode)node.getChild(1));
        String integerComputation = JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genBinaryOp(javaOpToken, JavaCodeUtils.genIntegerValue(operand0), JavaCodeUtils.genIntegerValue(operand1)));
        String floatComputation = JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genBinaryOp(javaOpToken, JavaCodeUtils.genNumberValue(operand0), JavaCodeUtils.genNumberValue(operand1)));
        if (JavaCodeUtils.isAlwaysTwoIntegers(operand0, operand1)) {
            return this.convertBooleanResult(integerComputation);
        }
        if (JavaCodeUtils.isAlwaysAtLeastOneFloat(operand0, operand1)) {
            return this.convertBooleanResult(floatComputation);
        }
        return this.convertBooleanResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils." + utilsLibFnName, JavaCodeUtils.genMaybeCast(operand0, NumberData.class), JavaCodeUtils.genMaybeCast(operand1, NumberData.class)));
    }

    private JavaExpr getLocalVarTranslation(String ident) {
        for (Map<String, JavaExpr> localVarTranslationsFrame : this.localVarTranslations) {
            JavaExpr translation = localVarTranslationsFrame.get(ident);
            if (translation == null) continue;
            return translation;
        }
        return null;
    }

    public static interface TranslateToJavaExprVisitorFactory {
        public TranslateToJavaExprVisitor create(Deque<Map<String, JavaExpr>> var1);
    }
}

