/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.JavaExprUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

class JavaCodeBuilder {
    private static final String SPACES = "                    ";
    private final StringBuilder code;
    private final SoyJavaSrcOptions.CodeStyle codeStyle;
    private String indent;
    private Deque<Pair<String, Boolean>> outputVars;
    private String currOutputVarName;
    private boolean currOutputVarIsInited;

    public JavaCodeBuilder(SoyJavaSrcOptions.CodeStyle codeStyle) {
        this.codeStyle = codeStyle;
        this.code = new StringBuilder();
        this.indent = "";
        this.outputVars = new ArrayDeque<Pair<String, Boolean>>();
        this.currOutputVarName = null;
        this.currOutputVarIsInited = false;
    }

    public void increaseIndent() throws SoySyntaxException {
        int newIndentDepth = this.indent.length() + 2;
        if (newIndentDepth > 20) {
            throw SoySyntaxException.createWithoutMetaInfo("Indent is more than 20 spaces!");
        }
        this.indent = SPACES.substring(0, newIndentDepth);
    }

    public void decreaseIndent() throws SoySyntaxException {
        int newIndentDepth = this.indent.length() - 2;
        if (newIndentDepth < 0) {
            throw SoySyntaxException.createWithoutMetaInfo("Indent is less than 0 spaces!");
        }
        this.indent = SPACES.substring(0, newIndentDepth);
    }

    public void pushOutputVar(String outputVarName) {
        this.outputVars.push(Pair.of(outputVarName, false));
        this.currOutputVarName = outputVarName;
        this.currOutputVarIsInited = false;
    }

    public void popOutputVar() {
        this.outputVars.pop();
        Pair<String, Boolean> topPair = this.outputVars.peek();
        if (topPair != null) {
            this.currOutputVarName = topPair.getFirst();
            this.currOutputVarIsInited = topPair.getSecond();
        } else {
            this.currOutputVarName = null;
            this.currOutputVarIsInited = false;
        }
    }

    public void setOutputVarInited() {
        this.outputVars.pop();
        this.outputVars.push(Pair.of(this.currOutputVarName, true));
        this.currOutputVarIsInited = true;
    }

    public JavaCodeBuilder indent() {
        this.code.append(this.indent);
        return this;
    }

    public JavaCodeBuilder append(String ... javaCodeFragments) {
        for (String javaCodeFragment : javaCodeFragments) {
            this.code.append(javaCodeFragment);
        }
        return this;
    }

    public JavaCodeBuilder appendLine(String ... javaCodeFragments) {
        this.indent();
        this.append(javaCodeFragments);
        this.code.append("\n");
        return this;
    }

    public JavaCodeBuilder appendOutputVarName() {
        this.code.append(this.currOutputVarName);
        return this;
    }

    public void initOutputVarIfNecessary() {
        if (this.currOutputVarIsInited) {
            return;
        }
        if (this.codeStyle == SoyJavaSrcOptions.CodeStyle.STRINGBUILDER) {
            this.appendLine("StringBuilder ", this.currOutputVarName, " = new StringBuilder();");
        } else {
            this.appendLine("String ", this.currOutputVarName, " = \"\";");
        }
        this.setOutputVarInited();
    }

    public void addToOutputVar(List<JavaExpr> javaExprs) {
        if (this.codeStyle == SoyJavaSrcOptions.CodeStyle.STRINGBUILDER) {
            StringBuilder joinedJavaExprsSb = new StringBuilder();
            boolean isFirst = true;
            for (JavaExpr javaExpr : javaExprs) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    joinedJavaExprsSb.append(").append(");
                }
                joinedJavaExprsSb.append(javaExpr.getText());
            }
            if (this.currOutputVarIsInited) {
                this.appendLine(this.currOutputVarName, ".append(", joinedJavaExprsSb.toString(), ");");
            } else {
                this.appendLine("StringBuilder ", this.currOutputVarName, " = (new StringBuilder()).append(", joinedJavaExprsSb.toString(), ");");
                this.setOutputVarInited();
            }
        } else {
            JavaExpr concatenatedJavaExprs = JavaExprUtils.concatJavaExprs(javaExprs);
            if (this.currOutputVarIsInited) {
                this.appendLine(this.currOutputVarName, " += ", concatenatedJavaExprs.getText(), ";");
            } else {
                this.appendLine("String ", this.currOutputVarName, " = ", concatenatedJavaExprs.getText(), ";");
                this.setOutputVarInited();
            }
        }
    }

    public String getCode() {
        return this.code.toString();
    }
}

