/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.shared.internal.ApiCallScope;
import com.google.template.soy.soytree.AbstractReturningSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Map;

@ApiCallScope
class IsComputableAsJavaExprsVisitor
extends AbstractReturningSoyNodeVisitor<Boolean> {
    private final SoyJavaSrcOptions javaSrcOptions;
    private final Map<SoyNode, Boolean> memoizedResults;

    @Inject
    public IsComputableAsJavaExprsVisitor(SoyJavaSrcOptions javaSrcOptions) {
        this.javaSrcOptions = javaSrcOptions;
        this.memoizedResults = Maps.newHashMap();
    }

    @Override
    protected Boolean visit(SoyNode node) {
        if (this.memoizedResults.containsKey(node)) {
            return this.memoizedResults.get(node);
        }
        Boolean result = (Boolean)super.visit(node);
        this.memoizedResults.put(node, result);
        return result;
    }

    @Override
    protected Boolean visitTemplateNode(TemplateNode node) {
        return this.areChildrenComputableAsJavaExprs(node);
    }

    @Override
    protected Boolean visitRawTextNode(RawTextNode node) {
        return true;
    }

    @Override
    protected Boolean visitMsgPlaceholderNode(MsgPlaceholderNode node) {
        return this.areChildrenComputableAsJavaExprs(node);
    }

    @Override
    protected Boolean visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        return this.areChildrenComputableAsJavaExprs(node);
    }

    @Override
    protected Boolean visitPrintNode(PrintNode node) {
        return true;
    }

    @Override
    protected Boolean visitCssNode(CssNode node) {
        return true;
    }

    @Override
    protected Boolean visitLetNode(LetNode node) {
        return false;
    }

    @Override
    protected Boolean visitIfNode(IfNode node) {
        return this.areChildrenComputableAsJavaExprs(node);
    }

    @Override
    protected Boolean visitIfCondNode(IfCondNode node) {
        return this.areChildrenComputableAsJavaExprs(node);
    }

    @Override
    protected Boolean visitIfElseNode(IfElseNode node) {
        return this.areChildrenComputableAsJavaExprs(node);
    }

    @Override
    protected Boolean visitSwitchNode(SwitchNode node) {
        return false;
    }

    @Override
    protected Boolean visitForeachNode(ForeachNode node) {
        return false;
    }

    @Override
    protected Boolean visitForNode(ForNode node) {
        return false;
    }

    @Override
    protected Boolean visitCallNode(CallNode node) {
        return this.javaSrcOptions.getCodeStyle() == SoyJavaSrcOptions.CodeStyle.CONCAT && this.areChildrenComputableAsJavaExprs(node);
    }

    @Override
    protected Boolean visitCallParamValueNode(CallParamValueNode node) {
        return true;
    }

    @Override
    protected Boolean visitCallParamContentNode(CallParamContentNode node) {
        return this.areChildrenComputableAsJavaExprs(node);
    }

    private boolean areChildrenComputableAsJavaExprs(SoyNode.ParentSoyNode<?> node) {
        for (SoyNode child : node.getChildren()) {
            if (child instanceof RawTextNode || child instanceof PrintNode || this.visit(child).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

