/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.base.CharEscapers;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.javasrc.internal.GenCallCodeUtils;
import com.google.template.soy.javasrc.internal.IsComputableAsJavaExprsVisitor;
import com.google.template.soy.javasrc.internal.TranslateToJavaExprVisitor;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.JavaExprUtils;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcPrintDirective;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoySyntaxExceptionUtils;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class GenJavaExprsVisitor
extends AbstractSoyNodeVisitor<List<JavaExpr>> {
    Map<String, SoyJavaSrcPrintDirective> soyJavaSrcDirectivesMap;
    private final SoyJavaSrcOptions javaSrcOptions;
    private final GenCallCodeUtils genCallCodeUtils;
    private final IsComputableAsJavaExprsVisitor isComputableAsJavaExprsVisitor;
    private final GenJavaExprsVisitorFactory genJavaExprsVisitorFactory;
    private final TranslateToJavaExprVisitor.TranslateToJavaExprVisitorFactory translateToJavaExprVisitorFactory;
    private final Deque<Map<String, JavaExpr>> localVarTranslations;
    private List<JavaExpr> javaExprs;

    @AssistedInject
    GenJavaExprsVisitor(Map<String, SoyJavaSrcPrintDirective> soyJavaSrcDirectivesMap, SoyJavaSrcOptions javaSrcOptions, GenCallCodeUtils genCallCodeUtils, IsComputableAsJavaExprsVisitor isComputableAsJavaExprsVisitor, GenJavaExprsVisitorFactory genJavaExprsVisitorFactory, TranslateToJavaExprVisitor.TranslateToJavaExprVisitorFactory translateToJavaExprVisitorFactory, @Assisted Deque<Map<String, JavaExpr>> localVarTranslations) {
        this.soyJavaSrcDirectivesMap = soyJavaSrcDirectivesMap;
        this.javaSrcOptions = javaSrcOptions;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJavaExprsVisitor = isComputableAsJavaExprsVisitor;
        this.genJavaExprsVisitorFactory = genJavaExprsVisitorFactory;
        this.translateToJavaExprVisitorFactory = translateToJavaExprVisitorFactory;
        this.localVarTranslations = localVarTranslations;
    }

    @Override
    public List<JavaExpr> exec(SoyNode node) {
        Preconditions.checkArgument((boolean)((Boolean)this.isComputableAsJavaExprsVisitor.exec(node)));
        this.javaExprs = Lists.newArrayList();
        this.visit(node);
        return this.javaExprs;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        this.javaExprs.add(new JavaExpr('\"' + CharEscapers.javaStringEscaper().escape(node.getRawText()) + '\"', String.class, Integer.MAX_VALUE));
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        TranslateToJavaExprVisitor ttjev = this.translateToJavaExprVisitorFactory.create(this.localVarTranslations);
        JavaExpr javaExpr = (JavaExpr)ttjev.exec(node.getExprUnion().getExpr());
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            SoyJavaSrcPrintDirective directive = this.soyJavaSrcDirectivesMap.get(directiveNode.getName());
            if (directive == null) {
                throw SoySyntaxExceptionUtils.createWithNode("Failed to find SoyJavaSrcPrintDirective with name '" + directiveNode.getName() + "'" + " (tag " + node.toSourceString() + ")", directiveNode);
            }
            List<ExprRootNode<?>> args = directiveNode.getArgs();
            if (!directive.getValidArgsSizes().contains(args.size())) {
                throw SoySyntaxExceptionUtils.createWithNode("Print directive '" + directiveNode.getName() + "' used with the wrong number of" + " arguments (tag " + node.toSourceString() + ").", directiveNode);
            }
            ArrayList argsJavaExprs = Lists.newArrayListWithCapacity((int)args.size());
            for (ExprRootNode<?> arg : args) {
                argsJavaExprs.add(ttjev.exec(arg));
            }
            javaExpr = directive.applyForJavaSrc(javaExpr, argsJavaExprs);
        }
        this.javaExprs.add(javaExpr);
    }

    @Override
    protected void visitIfNode(IfNode node) {
        GenJavaExprsVisitor genJavaExprsVisitor = this.genJavaExprsVisitorFactory.create(this.localVarTranslations);
        StringBuilder javaExprTextSb = new StringBuilder();
        boolean hasElse = false;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                JavaExpr condJavaExpr = (JavaExpr)this.translateToJavaExprVisitorFactory.create(this.localVarTranslations).exec(icn.getExprUnion().getExpr());
                javaExprTextSb.append('(').append(JavaCodeUtils.genCoerceBoolean(condJavaExpr)).append(") ? ");
                List<JavaExpr> condBlockJavaExprs = genJavaExprsVisitor.exec(icn);
                javaExprTextSb.append(JavaCodeUtils.genMaybeProtect(JavaExprUtils.concatJavaExprs(condBlockJavaExprs), Operator.CONDITIONAL.getPrecedence() + 1));
                javaExprTextSb.append(" : ");
                continue;
            }
            if (child instanceof IfElseNode) {
                hasElse = true;
                IfElseNode ien = (IfElseNode)child;
                List<JavaExpr> elseBlockJavaExprs = genJavaExprsVisitor.exec(ien);
                javaExprTextSb.append(JavaCodeUtils.genMaybeProtect(JavaExprUtils.concatJavaExprs(elseBlockJavaExprs), Operator.CONDITIONAL.getPrecedence() + 1));
                continue;
            }
            throw new AssertionError();
        }
        if (!hasElse) {
            javaExprTextSb.append("\"\"");
        }
        this.javaExprs.add(new JavaExpr(javaExprTextSb.toString(), String.class, Operator.CONDITIONAL.getPrecedence()));
    }

    @Override
    protected void visitIfCondNode(IfCondNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitIfElseNode(IfElseNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        this.javaExprs.add(this.genCallCodeUtils.genCallExpr(node, this.localVarTranslations));
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitCssNode(CssNode node) {
        ExprRootNode<?> componentNameExpr = node.getComponentNameExpr();
        if (componentNameExpr != null) {
            TranslateToJavaExprVisitor ttjev = this.translateToJavaExprVisitorFactory.create(this.localVarTranslations);
            this.javaExprs.add((JavaExpr)ttjev.exec(componentNameExpr));
            this.javaExprs.add(new JavaExpr("\"-\"", StringData.class, Integer.MAX_VALUE));
        }
        String selectorText = node.getSelectorText();
        SoyCssRenamingMap cssRenamingHints = this.javaSrcOptions.getCssRenamingHints();
        String renamedSelectorText = cssRenamingHints.get(selectorText);
        if (renamedSelectorText != null && renamedSelectorText.length() != 0) {
            String javaRenamedSelectorText = '\"' + CharEscapers.javaStringEscaper().escape(renamedSelectorText) + '\"';
            this.javaExprs.add(new JavaExpr(javaRenamedSelectorText, StringData.class, Integer.MAX_VALUE));
        } else {
            String javaSelectorText = '\"' + CharEscapers.javaStringEscaper().escape(selectorText) + '\"';
            this.javaExprs.add(new JavaExpr("this.$$renameCss(" + javaSelectorText + ")", StringData.class, Integer.MAX_VALUE));
        }
    }

    public static interface GenJavaExprsVisitorFactory {
        public GenJavaExprsVisitor create(Deque<Map<String, JavaExpr>> var1);
    }
}

