/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.template.soy.base.SoyFileKind;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.javasrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.javasrc.internal.GenCallCodeUtils;
import com.google.template.soy.javasrc.internal.GenJavaExprsVisitor;
import com.google.template.soy.javasrc.internal.IsComputableAsJavaExprsVisitor;
import com.google.template.soy.javasrc.internal.JavaCodeBuilder;
import com.google.template.soy.javasrc.internal.TranslateToJavaExprVisitor;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.JavaExprUtils;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoySyntaxExceptionUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

class GenJavaCodeVisitor
extends AbstractSoyNodeVisitor<String> {
    private static final Pattern INTEGER = Pattern.compile("-?\\d+");
    private final SoyJavaSrcOptions javaSrcOptions;
    private final GenCallCodeUtils genCallCodeUtils;
    private final IsComputableAsJavaExprsVisitor isComputableAsJavaExprsVisitor;
    private final CanInitOutputVarVisitor canInitOutputVarVisitor;
    private final GenJavaExprsVisitor.GenJavaExprsVisitorFactory genJavaExprsVisitorFactory;
    private final TranslateToJavaExprVisitor.TranslateToJavaExprVisitorFactory translateToJavaExprVisitorFactory;
    @VisibleForTesting
    protected GenJavaExprsVisitor genJavaExprsVisitor;
    @VisibleForTesting
    protected JavaCodeBuilder javaCodeBuilder;
    @VisibleForTesting
    protected Deque<Map<String, JavaExpr>> localVarTranslations;

    @Inject
    GenJavaCodeVisitor(SoyJavaSrcOptions javaSrcOptions, GenCallCodeUtils genCallCodeUtils, IsComputableAsJavaExprsVisitor isComputableAsJavaExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenJavaExprsVisitor.GenJavaExprsVisitorFactory genJavaExprsVisitorFactory, TranslateToJavaExprVisitor.TranslateToJavaExprVisitorFactory translateToJavaExprVisitorFactory) {
        this.javaSrcOptions = javaSrcOptions;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJavaExprsVisitor = isComputableAsJavaExprsVisitor;
        this.canInitOutputVarVisitor = canInitOutputVarVisitor;
        this.genJavaExprsVisitorFactory = genJavaExprsVisitorFactory;
        this.translateToJavaExprVisitorFactory = translateToJavaExprVisitorFactory;
    }

    @Override
    public String exec(SoyNode node) {
        this.javaCodeBuilder = new JavaCodeBuilder(this.javaSrcOptions.getCodeStyle());
        this.localVarTranslations = null;
        this.visit(node);
        return this.javaCodeBuilder.getCode();
    }

    @Override
    @VisibleForTesting
    protected void visit(SoyNode node) {
        super.visit(node);
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        if (node.numChildren() == 0 || !((Boolean)this.canInitOutputVarVisitor.exec(node.getChild(0))).booleanValue()) {
            this.javaCodeBuilder.initOutputVarIfNecessary();
        }
        ArrayList consecChildrenJavaExprs = Lists.newArrayList();
        for (SoyNode child : node.getChildren()) {
            if (((Boolean)this.isComputableAsJavaExprsVisitor.exec(child)).booleanValue()) {
                consecChildrenJavaExprs.addAll(this.genJavaExprsVisitor.exec(child));
                continue;
            }
            if (consecChildrenJavaExprs.size() > 0) {
                this.javaCodeBuilder.addToOutputVar(consecChildrenJavaExprs);
                consecChildrenJavaExprs.clear();
            }
            this.visit(child);
        }
        if (consecChildrenJavaExprs.size() > 0) {
            this.javaCodeBuilder.addToOutputVar(consecChildrenJavaExprs);
            consecChildrenJavaExprs.clear();
        }
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        boolean isFirst = true;
        for (SoyFileNode soyFile : node.getChildren()) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.javaCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            }
            try {
                this.visit(soyFile);
            }
            catch (SoySyntaxException sse) {
                throw sse.associateMetaInfo(null, soyFile.getFilePath(), null);
            }
        }
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        if (node.getSoyFileKind() == SoyFileKind.DEP) {
            return;
        }
        this.javaCodeBuilder.appendLine("// ----------------------------------------------------------------------------- ");
        this.javaCodeBuilder.appendLine("// The functions below were generated from ", node.getFileName(), ".");
        for (TemplateNode template : node.getChildren()) {
            this.javaCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            try {
                this.visit(template);
            }
            catch (SoySyntaxException sse) {
                throw sse.associateMetaInfo(null, null, template.getTemplateNameForUserMsgs());
            }
        }
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        boolean shouldReturn;
        String params;
        boolean isCodeStyleStringbuilder = this.javaSrcOptions.getCodeStyle() == SoyJavaSrcOptions.CodeStyle.STRINGBUILDER;
        this.localVarTranslations = new ArrayDeque<Map<String, JavaExpr>>();
        this.genJavaExprsVisitor = this.genJavaExprsVisitorFactory.create(this.localVarTranslations);
        boolean isPrivate = node.isPrivate();
        String modifiers = isPrivate ? "private" : "public";
        if (isCodeStyleStringbuilder && isPrivate) {
            params = "com.google.template.soy.data.SoyMapData data, StringBuilder output";
            shouldReturn = false;
        } else {
            params = isCodeStyleStringbuilder ? "com.google.template.soy.data.SoyMapData data, StringBuilder sb" : "com.google.template.soy.data.SoyMapData data";
            shouldReturn = true;
        }
        this.javaCodeBuilder.appendLine(modifiers, shouldReturn ? " String " : " void ", node.getTemplateName().replace('.', '$'), "(" + params + ") {");
        this.javaCodeBuilder.increaseIndent();
        this.localVarTranslations.push(Maps.newHashMap());
        if (!isCodeStyleStringbuilder && ((Boolean)this.isComputableAsJavaExprsVisitor.exec(node)).booleanValue()) {
            List<JavaExpr> templateBodyJavaExprs = this.genJavaExprsVisitor.exec(node);
            JavaExpr templateBodyJavaExpr = JavaExprUtils.concatJavaExprs(templateBodyJavaExprs);
            this.javaCodeBuilder.appendLine("return ", templateBodyJavaExpr.getText(), ";");
        } else {
            this.javaCodeBuilder.pushOutputVar("output");
            if (isCodeStyleStringbuilder) {
                if (!isPrivate) {
                    this.javaCodeBuilder.appendLine("StringBuilder output = (sb != null) ? sb : new StringBuilder();");
                }
                this.javaCodeBuilder.setOutputVarInited();
            }
            this.visitChildren(node);
            if (shouldReturn) {
                if (isCodeStyleStringbuilder) {
                    this.javaCodeBuilder.appendLine("return (sb != null) ? null : output.toString();");
                } else {
                    this.javaCodeBuilder.appendLine("return output;");
                }
            }
            this.javaCodeBuilder.popOutputVar();
        }
        this.localVarTranslations.pop();
        this.javaCodeBuilder.decreaseIndent();
        this.javaCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        String generatedVarName = node.getUniqueVarName();
        JavaExpr valueJavaExpr = (JavaExpr)this.translateToJavaExprVisitorFactory.create(this.localVarTranslations).exec(node.getValueExpr());
        this.javaCodeBuilder.appendLine("final com.google.template.soy.data.SoyData ", generatedVarName, " = ", valueJavaExpr.getText(), ";");
        this.localVarTranslations.peek().put(node.getVarName(), new JavaExpr(generatedVarName, SoyData.class, Integer.MAX_VALUE));
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        if (node.getContentKind() != null) {
            throw SoySyntaxExceptionUtils.createWithNode("JavaSrc backend doesn't support let blocks with 'kind' attribute.", node);
        }
        String generatedVarName = node.getUniqueVarName();
        this.localVarTranslations.push(Maps.newHashMap());
        if (this.javaSrcOptions.getCodeStyle() == SoyJavaSrcOptions.CodeStyle.STRINGBUILDER) {
            this.javaCodeBuilder.pushOutputVar(generatedVarName + "_sb");
        } else {
            this.javaCodeBuilder.pushOutputVar(generatedVarName);
        }
        this.visitChildren(node);
        this.javaCodeBuilder.popOutputVar();
        this.localVarTranslations.pop();
        if (this.javaSrcOptions.getCodeStyle() == SoyJavaSrcOptions.CodeStyle.STRINGBUILDER) {
            this.javaCodeBuilder.appendLine("String ", generatedVarName, " = ", generatedVarName, "_sb.toString();");
        }
        this.localVarTranslations.peek().put(node.getVarName(), new JavaExpr(generatedVarName, SoyData.class, Integer.MAX_VALUE));
    }

    @Override
    protected void visitIfNode(IfNode node) {
        if (((Boolean)this.isComputableAsJavaExprsVisitor.exec(node)).booleanValue()) {
            this.javaCodeBuilder.addToOutputVar(this.genJavaExprsVisitor.exec(node));
            return;
        }
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                JavaExpr condJavaExpr = (JavaExpr)this.translateToJavaExprVisitorFactory.create(this.localVarTranslations).exec(icn.getExprUnion().getExpr());
                if (icn.getCommandName().equals("if")) {
                    this.javaCodeBuilder.appendLine("if (", JavaCodeUtils.genCoerceBoolean(condJavaExpr), ") {");
                } else {
                    this.javaCodeBuilder.appendLine("} else if (", JavaCodeUtils.genCoerceBoolean(condJavaExpr), ") {");
                }
                this.javaCodeBuilder.increaseIndent();
                this.visit(icn);
                this.javaCodeBuilder.decreaseIndent();
                continue;
            }
            if (child instanceof IfElseNode) {
                IfElseNode ien = (IfElseNode)child;
                this.javaCodeBuilder.appendLine("} else {");
                this.javaCodeBuilder.increaseIndent();
                this.visit(ien);
                this.javaCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError();
        }
        this.javaCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitSwitchNode(SwitchNode node) {
        TranslateToJavaExprVisitor ttjev = this.translateToJavaExprVisitorFactory.create(this.localVarTranslations);
        JavaExpr switchValueJavaExpr = (JavaExpr)ttjev.exec(node.getExpr());
        String switchValueVarName = "switchValue" + node.getId();
        this.javaCodeBuilder.appendLine("com.google.template.soy.data.SoyData ", switchValueVarName, " = ", switchValueJavaExpr.getText(), ";");
        boolean isFirstCase = true;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode scn = (SwitchCaseNode)child;
                StringBuilder conditionExprText = new StringBuilder();
                boolean isFirstCaseValue = true;
                for (ExprRootNode<?> caseExpr : scn.getExprList()) {
                    JavaExpr caseJavaExpr = (JavaExpr)ttjev.exec(caseExpr);
                    if (isFirstCaseValue) {
                        isFirstCaseValue = false;
                    } else {
                        conditionExprText.append(" || ");
                    }
                    conditionExprText.append(switchValueVarName).append(".equals(").append(caseJavaExpr.getText()).append(')');
                }
                if (isFirstCase) {
                    isFirstCase = false;
                    this.javaCodeBuilder.appendLine("if (", conditionExprText.toString(), ") {");
                } else {
                    this.javaCodeBuilder.appendLine("} else if (", conditionExprText.toString(), ") {");
                }
                this.javaCodeBuilder.increaseIndent();
                this.visit(scn);
                this.javaCodeBuilder.decreaseIndent();
                continue;
            }
            if (child instanceof SwitchDefaultNode) {
                SwitchDefaultNode sdn = (SwitchDefaultNode)child;
                this.javaCodeBuilder.appendLine("} else {");
                this.javaCodeBuilder.increaseIndent();
                this.visit(sdn);
                this.javaCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError();
        }
        this.javaCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitForeachNode(ForeachNode node) {
        boolean hasIfemptyNode;
        String baseVarName = node.getVarName();
        String nodeId = Integer.toString(node.getId());
        String listVarName = baseVarName + "List" + nodeId;
        String listLenVarName = baseVarName + "ListLen" + nodeId;
        JavaExpr dataRefJavaExpr = (JavaExpr)this.translateToJavaExprVisitorFactory.create(this.localVarTranslations).exec(node.getExpr());
        this.javaCodeBuilder.appendLine("com.google.template.soy.data.SoyListData ", listVarName, " = (com.google.template.soy.data.SoyListData) ", dataRefJavaExpr.getText(), ";");
        this.javaCodeBuilder.appendLine("int ", listLenVarName, " = ", listVarName, ".length();");
        boolean bl = hasIfemptyNode = node.numChildren() == 2;
        if (hasIfemptyNode) {
            this.javaCodeBuilder.appendLine("if (", listLenVarName, " > 0) {");
            this.javaCodeBuilder.increaseIndent();
        }
        this.visit((SoyNode)node.getChild(0));
        if (hasIfemptyNode) {
            this.javaCodeBuilder.decreaseIndent();
            this.javaCodeBuilder.appendLine("} else {");
            this.javaCodeBuilder.increaseIndent();
            this.visit((SoyNode)node.getChild(1));
            this.javaCodeBuilder.decreaseIndent();
            this.javaCodeBuilder.appendLine("}");
        }
    }

    @Override
    protected void visitForeachNonemptyNode(ForeachNonemptyNode node) {
        String baseVarName = node.getVarName();
        String foreachNodeId = Integer.toString(node.getForeachNodeId());
        String listVarName = baseVarName + "List" + foreachNodeId;
        String listLenVarName = baseVarName + "ListLen" + foreachNodeId;
        String indexVarName = baseVarName + "Index" + foreachNodeId;
        String dataVarName = baseVarName + "Data" + foreachNodeId;
        this.javaCodeBuilder.appendLine("for (int ", indexVarName, " = 0; ", indexVarName, " < ", listLenVarName, "; ", indexVarName, "++) {");
        this.javaCodeBuilder.increaseIndent();
        this.javaCodeBuilder.appendLine("com.google.template.soy.data.SoyData ", dataVarName, " = ", listVarName, ".get(", indexVarName, ");");
        HashMap newLocalVarTranslationsFrame = Maps.newHashMap();
        newLocalVarTranslationsFrame.put(baseVarName, new JavaExpr(dataVarName, SoyData.class, Integer.MAX_VALUE));
        newLocalVarTranslationsFrame.put(baseVarName + "__isFirst", new JavaExpr("com.google.template.soy.data.restricted.BooleanData.forValue(" + indexVarName + " == 0)", BooleanData.class, Integer.MAX_VALUE));
        newLocalVarTranslationsFrame.put(baseVarName + "__isLast", new JavaExpr("com.google.template.soy.data.restricted.BooleanData.forValue(" + indexVarName + " == " + listLenVarName + " - 1)", BooleanData.class, Integer.MAX_VALUE));
        newLocalVarTranslationsFrame.put(baseVarName + "__index", new JavaExpr("com.google.template.soy.data.restricted.IntegerData.forValue(" + indexVarName + ")", IntegerData.class, Integer.MAX_VALUE));
        this.localVarTranslations.push(newLocalVarTranslationsFrame);
        this.visitChildren(node);
        this.localVarTranslations.pop();
        this.javaCodeBuilder.decreaseIndent();
        this.javaCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitForNode(ForNode node) {
        String incrementCode;
        String limitCode;
        String initCode;
        String varName = node.getVarName();
        String nodeId = Integer.toString(node.getId());
        TranslateToJavaExprVisitor ttjev = this.translateToJavaExprVisitorFactory.create(this.localVarTranslations);
        ArrayList rangeArgs = Lists.newArrayList(node.getRangeArgs());
        String incrementJavaExprText = rangeArgs.size() == 3 ? JavaCodeUtils.genIntegerValue((JavaExpr)ttjev.exec((Node)rangeArgs.remove(2))) : "1";
        String initJavaExprText = rangeArgs.size() == 2 ? JavaCodeUtils.genIntegerValue((JavaExpr)ttjev.exec((Node)rangeArgs.remove(0))) : "0";
        String limitJavaExprText = JavaCodeUtils.genIntegerValue((JavaExpr)ttjev.exec((Node)rangeArgs.get(0)));
        if (INTEGER.matcher(initJavaExprText).matches()) {
            initCode = initJavaExprText;
        } else {
            initCode = varName + "Init" + nodeId;
            this.javaCodeBuilder.appendLine("int ", initCode, " = ", initJavaExprText, ";");
        }
        if (INTEGER.matcher(limitJavaExprText).matches()) {
            limitCode = limitJavaExprText;
        } else {
            limitCode = varName + "Limit" + nodeId;
            this.javaCodeBuilder.appendLine("int ", limitCode, " = ", limitJavaExprText, ";");
        }
        if (INTEGER.matcher(incrementJavaExprText).matches()) {
            incrementCode = incrementJavaExprText;
        } else {
            incrementCode = varName + "Increment" + nodeId;
            this.javaCodeBuilder.appendLine("int ", incrementCode, " = ", incrementJavaExprText, ";");
        }
        String incrementStmt = incrementCode.equals("1") ? varName + nodeId + "++" : varName + nodeId + " += " + incrementCode;
        this.javaCodeBuilder.appendLine("for (int ", varName, nodeId, " = ", initCode, "; ", varName, nodeId, " < ", limitCode, "; ", incrementStmt, ") {");
        this.javaCodeBuilder.increaseIndent();
        HashMap newLocalVarTranslationsFrame = Maps.newHashMap();
        newLocalVarTranslationsFrame.put(varName, new JavaExpr("com.google.template.soy.data.restricted.IntegerData.forValue(" + varName + nodeId + ")", IntegerData.class, Integer.MAX_VALUE));
        this.localVarTranslations.push(newLocalVarTranslationsFrame);
        this.visitChildren(node);
        this.localVarTranslations.pop();
        this.javaCodeBuilder.decreaseIndent();
        this.javaCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitCallNode(CallNode node) {
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJavaExprsVisitor.exec(child)).booleanValue()) continue;
            this.visit(child);
        }
        if (this.javaSrcOptions.getCodeStyle() == SoyJavaSrcOptions.CodeStyle.STRINGBUILDER) {
            if (!(node instanceof CallBasicNode)) {
                throw new UnsupportedOperationException("Delegates are not supported in JavaSrc backend.");
            }
            JavaExpr objToPass = this.genCallCodeUtils.genObjToPass(node, this.localVarTranslations);
            this.javaCodeBuilder.indent().append(((CallBasicNode)node).getCalleeName().replace('.', '$')).append("(", objToPass.getText(), ", ").appendOutputVarName().append(");\n");
        } else {
            JavaExpr callExpr = this.genCallCodeUtils.genCallExpr(node, this.localVarTranslations);
            this.javaCodeBuilder.addToOutputVar((List<JavaExpr>)ImmutableList.of((Object)callExpr));
        }
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        if (((Boolean)this.isComputableAsJavaExprsVisitor.exec(node)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'param<n>' when not computable as Java expressions.");
        }
        this.localVarTranslations.push(Maps.newHashMap());
        this.javaCodeBuilder.pushOutputVar("param" + node.getId());
        this.visitChildren(node);
        this.javaCodeBuilder.popOutputVar();
        this.localVarTranslations.pop();
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            if (node instanceof SoyNode.BlockNode) {
                this.localVarTranslations.push(Maps.newHashMap());
                this.visitChildren((SoyNode.BlockNode)node);
                this.localVarTranslations.pop();
            } else {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
            return;
        }
        if (!((Boolean)this.isComputableAsJavaExprsVisitor.exec(node)).booleanValue()) {
            throw new UnsupportedOperationException();
        }
        this.javaCodeBuilder.addToOutputVar(this.genJavaExprsVisitor.exec(node));
    }
}

