/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.inject.Inject;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.javasrc.internal.GenJavaExprsVisitor;
import com.google.template.soy.javasrc.internal.IsComputableAsJavaExprsVisitor;
import com.google.template.soy.javasrc.internal.TranslateToJavaExprVisitor;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.JavaExprUtils;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.SoySyntaxExceptionUtils;
import java.util.Deque;
import java.util.List;
import java.util.Map;

class GenCallCodeUtils {
    private final SoyJavaSrcOptions javaSrcOptions;
    private final IsComputableAsJavaExprsVisitor isComputableAsJavaExprsVisitor;
    private final GenJavaExprsVisitor.GenJavaExprsVisitorFactory genJavaExprsVisitorFactory;
    private final TranslateToJavaExprVisitor.TranslateToJavaExprVisitorFactory translateToJavaExprVisitorFactory;

    @Inject
    GenCallCodeUtils(SoyJavaSrcOptions javaSrcOptions, IsComputableAsJavaExprsVisitor isComputableAsJavaExprsVisitor, GenJavaExprsVisitor.GenJavaExprsVisitorFactory genJavaExprsVisitorFactory, TranslateToJavaExprVisitor.TranslateToJavaExprVisitorFactory translateToJavaExprVisitorFactory) {
        this.javaSrcOptions = javaSrcOptions;
        this.isComputableAsJavaExprsVisitor = isComputableAsJavaExprsVisitor;
        this.genJavaExprsVisitorFactory = genJavaExprsVisitorFactory;
        this.translateToJavaExprVisitorFactory = translateToJavaExprVisitorFactory;
    }

    public JavaExpr genCallExpr(CallNode callNode, Deque<Map<String, JavaExpr>> localVarTranslations) {
        if (!(callNode instanceof CallBasicNode)) {
            throw new UnsupportedOperationException("Delegates are not supported in JavaSrc backend.");
        }
        JavaExpr objToPass = this.genObjToPass(callNode, localVarTranslations);
        return new JavaExpr(((CallBasicNode)callNode).getCalleeName().replace('.', '$') + "(" + objToPass.getText() + ")", String.class, Integer.MAX_VALUE);
    }

    public JavaExpr genObjToPass(CallNode callNode, Deque<Map<String, JavaExpr>> localVarTranslations) {
        TranslateToJavaExprVisitor ttjev = this.translateToJavaExprVisitorFactory.create(localVarTranslations);
        JavaExpr dataToPass = callNode.isPassingAllData() ? new JavaExpr("data", SoyMapData.class, Integer.MAX_VALUE) : (callNode.isPassingData() ? new JavaExpr(JavaCodeUtils.genMaybeCast((JavaExpr)ttjev.exec(callNode.getDataExpr()), SoyMapData.class), SoyMapData.class, Integer.MAX_VALUE) : new JavaExpr("null", SoyMapData.class, Integer.MAX_VALUE));
        if (callNode.numChildren() == 0) {
            return dataToPass;
        }
        StringBuilder paramsObjSb = new StringBuilder();
        paramsObjSb.append("new com.google.template.soy.data.SoyMapData(");
        boolean isFirst = true;
        for (CallParamNode child : callNode.getChildren()) {
            if (isFirst) {
                isFirst = false;
            } else {
                paramsObjSb.append(", ");
            }
            String key = child.getKey();
            paramsObjSb.append('\"').append(key).append("\", ");
            if (child instanceof CallParamValueNode) {
                CallParamValueNode cpvn = (CallParamValueNode)child;
                JavaExpr valueJavaExpr = (JavaExpr)ttjev.exec(cpvn.getValueExprUnion().getExpr());
                paramsObjSb.append(valueJavaExpr.getText());
                continue;
            }
            CallParamContentNode cpcn = (CallParamContentNode)child;
            if (cpcn.getContentKind() != null) {
                throw SoySyntaxExceptionUtils.createWithNode("JavaSrc backend doesn't support param blocks with 'kind' attribute.", cpcn);
            }
            if (((Boolean)this.isComputableAsJavaExprsVisitor.exec(cpcn)).booleanValue()) {
                List<JavaExpr> cpcnJavaExprs = this.genJavaExprsVisitorFactory.create(localVarTranslations).exec(cpcn);
                JavaExpr valueJavaExpr = JavaExprUtils.concatJavaExprs(cpcnJavaExprs);
                paramsObjSb.append(valueJavaExpr.getText());
                continue;
            }
            if (this.javaSrcOptions.getCodeStyle() == SoyJavaSrcOptions.CodeStyle.STRINGBUILDER) {
                paramsObjSb.append("param").append(cpcn.getId()).append(".toString()");
                continue;
            }
            paramsObjSb.append("param").append(cpcn.getId());
        }
        paramsObjSb.append(')');
        if (callNode.isPassingData()) {
            return new JavaExpr(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$augmentData", dataToPass.getText(), paramsObjSb.toString()), SoyMapData.class, Integer.MAX_VALUE);
        }
        return new JavaExpr(paramsObjSb.toString(), SoyMapData.class, Integer.MAX_VALUE);
    }
}

