/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.dyncompile;

import com.google.common.base.Charsets;
import com.google.template.soy.javasrc.dyncompile.InMemoryJavaFileObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.tools.JavaFileObject;

final class WritableInMemoryJavaFileObject
extends InMemoryJavaFileObject {
    private final ByteArrayOutputStream content = new ByteArrayOutputStream();

    WritableInMemoryJavaFileObject(String path) {
        super(path);
    }

    public byte[] getByteContent() {
        return this.content.toByteArray();
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.CLASS;
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.content.toByteArray());
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) {
        return new InputStreamReader(this.openInputStream(), Charsets.UTF_8);
    }

    @Override
    public OutputStream openOutputStream() {
        return this.content;
    }

    @Override
    public Writer openWriter() {
        return new OutputStreamWriter((OutputStream)this.content, Charsets.UTF_8);
    }
}

