/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.dyncompile;

import com.google.common.base.Charsets;
import com.google.template.soy.javasrc.dyncompile.InMemoryJavaFileObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.tools.JavaFileObject;

final class ReadableInMemoryJavaFileObject
extends InMemoryJavaFileObject {
    private final String content;

    ReadableInMemoryJavaFileObject(String path, String content) {
        super(path);
        this.content = content;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.SOURCE;
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(("\ufeff" + this.content).getBytes(Charsets.UTF_8));
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) {
        return new StringReader(this.content);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return this.content;
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new IOException(this.getPath() + " not writable");
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new IOException(this.getPath() + " not writable");
    }
}

