/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.dyncompile;

import com.google.common.base.Throwables;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;

abstract class InMemoryJavaFileObject
implements JavaFileObject {
    static final long IN_THE_YEAR_2000_MILLIS = 31557600000L;
    private final String path;

    InMemoryJavaFileObject(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public URI toUri() {
        try {
            return new URI("memory", null, null, 0, this.path, null, null);
        }
        catch (URISyntaxException ex) {
            Throwables.propagate((Throwable)ex);
            return null;
        }
    }

    @Override
    public String getName() {
        return this.path.substring(this.path.lastIndexOf(47) + 1);
    }

    @Override
    public long getLastModified() {
        return 31557600000L;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        if (kind != this.getKind()) {
            return false;
        }
        String name = this.getName();
        int dotIndex = name.indexOf(46);
        String nameWithoutExtension = dotIndex >= 0 ? name.substring(0, dotIndex) : name;
        return kind == this.getKind() && simpleName.equals(nameWithoutExtension);
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return CharStreams.toString((Readable)this.openReader(ignoreEncodingErrors));
    }

    public String toString() {
        return this.path;
    }
}

