/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.dyncompile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.javasrc.dyncompile.ClasspathJavaFileObject;
import com.google.template.soy.javasrc.dyncompile.ClasspathUtils;
import com.google.template.soy.javasrc.dyncompile.InMemoryJavaFileObject;
import com.google.template.soy.javasrc.dyncompile.ReadableInMemoryJavaFileObject;
import com.google.template.soy.javasrc.dyncompile.WritableInMemoryJavaFileObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

final class DynamicCompilerJavaFileManager
implements JavaFileManager {
    private final List<ReadableInMemoryJavaFileObject> inputFiles = Lists.newArrayList();
    private final List<WritableInMemoryJavaFileObject> outputFiles = Lists.newArrayList();
    private final StandardJavaFileManager standardFileManager;

    DynamicCompilerJavaFileManager(StandardJavaFileManager standardFileManager) {
        this.standardFileManager = standardFileManager;
    }

    List<ReadableInMemoryJavaFileObject> getInputFiles() {
        return ImmutableList.copyOf(this.inputFiles);
    }

    List<WritableInMemoryJavaFileObject> getOutputFiles() {
        return ImmutableList.copyOf(this.outputFiles);
    }

    void addInput(ReadableInMemoryJavaFileObject inputFile) {
        this.inputFiles.add(inputFile);
    }

    @Override
    public int isSupportedOption(String option) {
        return -1;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return null;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        ImmutableList.Builder results = ImmutableList.builder();
        if (StandardLocation.SOURCE_PATH.equals(location) && kinds.contains((Object)JavaFileObject.Kind.SOURCE) && ("com.google.template.soy.javasrc.dyncompiled".equals(packageName) || recurse && "com.google.template.soy.javasrc.dyncompiled".startsWith(packageName + "."))) {
            results.addAll(this.inputFiles);
        }
        if (StandardLocation.CLASS_PATH.equals(location) && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            for (String classResourcePath : ClasspathUtils.getClassResourcePaths(packageName, recurse)) {
                results.add((Object)new ClasspathJavaFileObject("/" + classResourcePath));
            }
        }
        if (StandardLocation.PLATFORM_CLASS_PATH.equals(location)) {
            results.addAll(this.standardFileManager.list(location, packageName, kinds, recurse));
        }
        return results.build();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        int dotIndex;
        String path;
        if (file instanceof InMemoryJavaFileObject) {
            path = ((InMemoryJavaFileObject)file).getPath();
            if (path.startsWith("/src/") || path.startsWith("/out/")) {
                path = path.substring(5);
            }
        } else if (file instanceof ClasspathJavaFileObject) {
            path = ((ClasspathJavaFileObject)file).getResourcePath();
        } else {
            return this.standardFileManager.inferBinaryName(location, file);
        }
        if ((dotIndex = path.lastIndexOf(46)) >= 0) {
            path = path.substring(0, dotIndex);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path.replace('/', '.');
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return a == b || a.toUri().equals(b.toUri());
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return StandardLocation.CLASS_OUTPUT.equals(location) || StandardLocation.SOURCE_PATH.equals(location) || StandardLocation.CLASS_PATH.equals(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        throw new IOException();
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (!StandardLocation.CLASS_OUTPUT.equals(location)) {
            throw new FileNotFoundException();
        }
        String outputPath = "/out/" + className.replace('.', '/') + ".class";
        for (WritableInMemoryJavaFileObject aJavaOutputFile : this.outputFiles) {
            if (!aJavaOutputFile.getPath().equals(outputPath)) continue;
            throw new IOException("Overwriting output file " + outputPath);
        }
        WritableInMemoryJavaFileObject javaFileForOutput = new WritableInMemoryJavaFileObject(outputPath);
        this.outputFiles.add(javaFileForOutput);
        return javaFileForOutput;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        throw new IOException();
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        throw new IOException();
    }

    @Override
    public void flush() throws IOException {
        this.standardFileManager.flush();
    }

    @Override
    public void close() throws IOException {
        this.standardFileManager.close();
    }
}

