/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.dyncompile;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

final class ClasspathUtils {
    private static final ClassLoader CLASS_LOADER = ClasspathUtils.class.getClassLoader() == null ? ClassLoader.getSystemClassLoader() : ClasspathUtils.class.getClassLoader();
    private static SoftReference<Map<String, PackageContent>> packagePathToContentMapRef;

    ClasspathUtils() {
    }

    static Iterable<String> getClassResourcePaths(String packageName, boolean isRecursive) throws IOException {
        URL url;
        ImmutableList.Builder classResourcePaths = ImmutableList.builder();
        String relativeUrl = packageName.replace('.', '/');
        PackageContent packageContent = ClasspathUtils.getPackagePathToContentMap().get(relativeUrl);
        if (packageContent != null) {
            packageContent.enumerateResources((ImmutableList.Builder<String>)classResourcePaths, isRecursive);
        }
        if ((url = CLASS_LOADER.getResource(relativeUrl)) != null) {
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                try {
                    ClasspathUtils.searchFileTree(packageName, new File(url.toURI()), isRecursive, (ImmutableList.Builder<? super String>)classResourcePaths);
                }
                catch (URISyntaxException ex) {
                    Throwables.propagate((Throwable)ex);
                }
            } else if ("jar".equals(protocol)) {
                ClasspathUtils.searchZipFile(packageName, isRecursive, url, (ImmutableList.Builder<? super String>)classResourcePaths);
            }
        }
        return classResourcePaths.build();
    }

    private static void searchFileTree(String packageName, File f, boolean isRecursive, ImmutableList.Builder<? super String> classResourcePaths) {
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                if (child.isFile()) {
                    if (!child.getName().endsWith(".class")) continue;
                    String packagePath = packageName.equals("") ? "" : packageName.replace('.', '/') + "/";
                    classResourcePaths.add((Object)(packagePath + child.getName()));
                    continue;
                }
                if (!isRecursive || !child.isDirectory() || ".".equals(child.getName()) || "..".equals(child.getName())) continue;
                String childPackageName = child.getName();
                if (!"".equals(packageName)) {
                    childPackageName = packageName + "." + childPackageName;
                }
                ClasspathUtils.searchFileTree(childPackageName, child, isRecursive, classResourcePaths);
            }
        }
    }

    private static void searchZipFile(String packageName, boolean isRecursive, URL url, ImmutableList.Builder<? super String> classResourcePaths) throws IOException {
        String urlString = url.toString();
        int bangIndex = urlString.lastIndexOf(33);
        URL zipFileUrl = new URL(urlString.substring(4, bangIndex));
        String pathInJar = urlString.substring(bangIndex + 1);
        ClasspathUtils.searchZipAtFileForPath(pathInJar, isRecursive, zipFileUrl, classResourcePaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void searchZipAtFileForPath(String pathInJar, boolean isRecursive, URL zipFileUrl, ImmutableList.Builder<? super String> classResourcePaths) throws IOException {
        InputStream in = zipFileUrl.openStream();
        try {
            ZipEntry zipEntry;
            ZipInputStream zipIn = new ZipInputStream(in);
            String prefix = pathInJar;
            if (pathInJar.startsWith("/")) {
                prefix = prefix.substring(1);
            }
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                String zipEntryName = zipEntry.getName();
                if (zipEntry.isDirectory() || !zipEntryName.endsWith(".class") || !zipEntryName.startsWith(prefix) || zipEntryName.lastIndexOf(47) != prefix.length() && (!isRecursive || prefix.length() != 0 && zipEntryName.charAt(prefix.length()) != '/')) continue;
                classResourcePaths.add((Object)zipEntryName);
            }
        }
        finally {
            in.close();
        }
    }

    private static Map<String, PackageContent> getPackagePathToContentMap() {
        Map<String, PackageContent> packagePathToContentMap = null;
        if (packagePathToContentMapRef != null) {
            packagePathToContentMap = packagePathToContentMapRef.get();
        }
        if (packagePathToContentMap == null) {
            packagePathToContentMap = ClasspathUtils.buildPackagePathToContentMapFromURLClassLoaders(CLASS_LOADER);
            packagePathToContentMapRef = new SoftReference<Map<String, PackageContent>>(packagePathToContentMap);
        }
        return packagePathToContentMap;
    }

    private static Map<String, PackageContent> buildPackagePathToContentMapFromURLClassLoaders(ClassLoader classLoader) {
        ImmutableList.Builder classResourcePaths = ImmutableList.builder();
        for (ClassLoader cl = classLoader; cl != null; cl = cl.getParent()) {
            if (!(cl instanceof URLClassLoader)) continue;
            for (URL classpathRoot : ((URLClassLoader)cl).getURLs()) {
                String protocol = classpathRoot.getProtocol();
                if (!"file".equals(protocol)) continue;
                try {
                    File f = new File(classpathRoot.toURI());
                    if (!f.exists()) continue;
                    try {
                        if (f.isDirectory()) {
                            ClasspathUtils.searchFileTree("", f, true, (ImmutableList.Builder<? super String>)classResourcePaths);
                            continue;
                        }
                        if (!f.isFile()) continue;
                        ClasspathUtils.searchZipAtFileForPath("", true, classpathRoot, (ImmutableList.Builder<? super String>)classResourcePaths);
                    }
                    catch (IOException ex) {}
                }
                catch (URISyntaxException ex) {
                    Throwables.propagate((Throwable)ex);
                }
            }
            break;
        }
        PackageTree packageTree = new PackageTree();
        for (String classResourcePath : classResourcePaths.build()) {
            int last = classResourcePath.lastIndexOf(47);
            String packagePart = last >= 0 ? classResourcePath.substring(0, last) : "";
            packageTree.getPackageContent((String)packagePart).resources.add(classResourcePath);
        }
        return ImmutableMap.copyOf(packageTree.packagePathToContentMap);
    }

    private static final class PackageContent {
        final List<PackageContent> subPackages = Lists.newArrayList();
        final List<String> resources = Lists.newArrayList();

        private PackageContent() {
        }

        void enumerateResources(ImmutableList.Builder<String> out, boolean recursive) {
            out.addAll(this.resources);
            if (recursive) {
                for (PackageContent subPackage : this.subPackages) {
                    subPackage.enumerateResources(out, true);
                }
            }
        }
    }

    private static final class PackageTree {
        final Map<String, PackageContent> packagePathToContentMap = Maps.newHashMap();

        private PackageTree() {
        }

        PackageContent getPackageContent(String packagePath) {
            PackageContent packageContent = this.packagePathToContentMap.get(packagePath);
            if (packageContent == null) {
                packageContent = new PackageContent();
                this.packagePathToContentMap.put(packagePath, packageContent);
                if (!"".equals(packagePath)) {
                    int lastSlash = packagePath.lastIndexOf(47);
                    String parentPackagePath = lastSlash < 0 ? "" : packagePath.substring(0, lastSlash);
                    this.getPackageContent((String)parentPackagePath).subPackages.add(packageContent);
                }
            }
            return packageContent;
        }
    }
}

