/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.codedeps;

import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.internal.AugmentedSoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.CollectionData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.shared.restricted.Sanitizers;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class SoyUtils {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("(\\r\\n|\\r|\\n)");

    public static SoyData $$getData(SoyData collectionData, String keyStr) {
        SoyData value = ((CollectionData)collectionData).get(keyStr);
        return value != null ? value : UndefinedData.INSTANCE;
    }

    public static SoyData $$getDataSingle(SoyData collectionData, String key) {
        SoyData value = ((CollectionData)collectionData).getSingle(key);
        return value != null ? value : UndefinedData.INSTANCE;
    }

    public static SoyMapData $$augmentData(SoyMapData baseData, SoyMapData additionalData) {
        AugmentedSoyMapData augmentedData = new AugmentedSoyMapData(baseData);
        for (Map.Entry<String, SoyData> entry : additionalData.asMap().entrySet()) {
            augmentedData.putSingle(entry.getKey(), entry.getValue());
        }
        return augmentedData;
    }

    public static String $$escapeHtml(SoyData value) {
        return Sanitizers.escapeHtml(value);
    }

    public static String $$escapeHtmlRcdata(SoyData value) {
        return Sanitizers.escapeHtmlRcdata(value);
    }

    public static String $$normalizeHtml(SoyData value) {
        return Sanitizers.normalizeHtml(value);
    }

    public static String $$normalizeHtmlNospace(SoyData value) {
        return Sanitizers.normalizeHtmlNospace(value);
    }

    public static String $$escapeHtmlAttribute(SoyData value) {
        return Sanitizers.escapeHtmlAttribute(value);
    }

    public static String $$escapeHtmlAttributeNospace(SoyData value) {
        return Sanitizers.escapeHtmlAttributeNospace(value);
    }

    public static String $$escapeJsString(SoyData value) {
        return Sanitizers.escapeJsString(value);
    }

    public static String $$escapeJsValue(SoyData value) {
        return Sanitizers.escapeJsValue(value);
    }

    public static String $$escapeJsRegex(SoyData value) {
        return Sanitizers.escapeJsRegex(value);
    }

    public static String $$escapeCssString(SoyData value) {
        return Sanitizers.escapeCssString(value);
    }

    public static String $$filterCssValue(SoyData value) {
        return Sanitizers.filterCssValue(value);
    }

    public static String $$escapeUri(SoyData value) {
        return Sanitizers.escapeUri(value);
    }

    public static String $$normalizeUri(SoyData value) {
        return Sanitizers.normalizeUri(value);
    }

    public static String $$filterNormalizeUri(SoyData value) {
        return Sanitizers.filterNormalizeUri(value);
    }

    public static String $$filterHtmlAttributes(SoyData value) {
        return Sanitizers.filterHtmlAttributes(value);
    }

    public static String $$filterHtmlElementName(SoyData value) {
        return Sanitizers.filterHtmlElementName(value);
    }

    public static String $$changeNewlineToBr(String value) {
        return NEWLINE_PATTERN.matcher(value).replaceAll("<br>");
    }

    public static String $$insertWordBreaks(String value, int maxCharsBetweenWordBreaks) {
        int codePoint;
        StringBuilder result = new StringBuilder();
        boolean isInTag = false;
        boolean isMaybeInEntity = false;
        int numCharsWithoutBreak = 0;
        for (int i = 0; i < value.length(); i += Character.charCount(codePoint)) {
            codePoint = value.codePointAt(i);
            if (numCharsWithoutBreak >= maxCharsBetweenWordBreaks && codePoint != 32) {
                result.append("<wbr>");
                numCharsWithoutBreak = 0;
            }
            if (isInTag) {
                if (codePoint == 62) {
                    isInTag = false;
                }
            } else if (isMaybeInEntity) {
                switch (codePoint) {
                    case 59: {
                        isMaybeInEntity = false;
                        ++numCharsWithoutBreak;
                        break;
                    }
                    case 60: {
                        isMaybeInEntity = false;
                        isInTag = true;
                        break;
                    }
                    case 32: {
                        isMaybeInEntity = false;
                        numCharsWithoutBreak = 0;
                    }
                }
            } else {
                switch (codePoint) {
                    case 60: {
                        isInTag = true;
                        break;
                    }
                    case 38: {
                        isMaybeInEntity = true;
                        break;
                    }
                    case 32: {
                        numCharsWithoutBreak = 0;
                        break;
                    }
                    default: {
                        ++numCharsWithoutBreak;
                    }
                }
            }
            result.appendCodePoint(codePoint);
        }
        return result.toString();
    }

    public static String $$truncate(String str, int maxLen, boolean doAddEllipsis) {
        if (str.length() <= maxLen) {
            return str;
        }
        if (doAddEllipsis) {
            if (maxLen > 3) {
                maxLen -= 3;
            } else {
                doAddEllipsis = false;
            }
        }
        if (Character.isHighSurrogate(str.charAt(maxLen - 1)) && Character.isLowSurrogate(str.charAt(maxLen))) {
            --maxLen;
        }
        str = str.substring(0, maxLen);
        if (doAddEllipsis) {
            str = str + "...";
        }
        return str;
    }

    public static NumberData $$negative(NumberData operand) {
        if (operand instanceof IntegerData) {
            return IntegerData.forValue(-operand.integerValue());
        }
        return FloatData.forValue(-operand.floatValue());
    }

    public static NumberData $$times(NumberData operand0, NumberData operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.integerValue() * operand1.integerValue());
        }
        return FloatData.forValue(operand0.numberValue() * operand1.numberValue());
    }

    public static SoyData $$plus(SoyData operand0, SoyData operand1) {
        if (operand0 instanceof NumberData && operand1 instanceof NumberData) {
            if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
                return IntegerData.forValue(operand0.integerValue() + operand1.integerValue());
            }
            return FloatData.forValue(operand0.numberValue() + operand1.numberValue());
        }
        return StringData.forValue(operand0.toString() + operand1.toString());
    }

    public static NumberData $$minus(NumberData operand0, NumberData operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.integerValue() - operand1.integerValue());
        }
        return FloatData.forValue(operand0.numberValue() - operand1.numberValue());
    }

    public static BooleanData $$lessThan(NumberData operand0, NumberData operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return BooleanData.forValue(operand0.integerValue() < operand1.integerValue());
        }
        return BooleanData.forValue(operand0.numberValue() < operand1.numberValue());
    }

    public static BooleanData $$greaterThan(NumberData operand0, NumberData operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return BooleanData.forValue(operand0.integerValue() > operand1.integerValue());
        }
        return BooleanData.forValue(operand0.numberValue() > operand1.numberValue());
    }

    public static BooleanData $$lessThanOrEqual(NumberData operand0, NumberData operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return BooleanData.forValue(operand0.integerValue() <= operand1.integerValue());
        }
        return BooleanData.forValue(operand0.numberValue() <= operand1.numberValue());
    }

    public static BooleanData $$greaterThanOrEqual(NumberData operand0, NumberData operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return BooleanData.forValue(operand0.integerValue() >= operand1.integerValue());
        }
        return BooleanData.forValue(operand0.numberValue() >= operand1.numberValue());
    }

    public static BooleanData $$isNonnull(SoyData value) {
        return BooleanData.forValue(!(value instanceof UndefinedData) && !(value instanceof NullData));
    }

    public static NumberData $$round(NumberData valueData, @Nullable IntegerData numDigitsAfterPtData) {
        int numDigitsAfterPt;
        int n = numDigitsAfterPt = numDigitsAfterPtData != null ? numDigitsAfterPtData.integerValue() : 0;
        if (numDigitsAfterPt == 0) {
            if (valueData instanceof IntegerData) {
                return valueData;
            }
            return IntegerData.forValue((int)Math.round(valueData.numberValue()));
        }
        if (numDigitsAfterPt > 0) {
            double value = valueData.numberValue();
            double shift = Math.pow(10.0, numDigitsAfterPt);
            return FloatData.forValue((double)Math.round(value * shift) / shift);
        }
        double value = valueData.numberValue();
        double shift = Math.pow(10.0, -numDigitsAfterPt);
        return IntegerData.forValue((int)((double)Math.round(value / shift) * shift));
    }

    public static NumberData $$min(NumberData arg0, NumberData arg1) {
        if (arg0 instanceof IntegerData && arg1 instanceof IntegerData) {
            return IntegerData.forValue(Math.min(arg0.integerValue(), arg1.integerValue()));
        }
        return FloatData.forValue(Math.min(arg0.numberValue(), arg1.numberValue()));
    }

    public static NumberData $$max(NumberData arg0, NumberData arg1) {
        if (arg0 instanceof IntegerData && arg1 instanceof IntegerData) {
            return IntegerData.forValue(Math.max(arg0.integerValue(), arg1.integerValue()));
        }
        return FloatData.forValue(Math.max(arg0.numberValue(), arg1.numberValue()));
    }
}

