/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.i18n;

import com.google.common.annotations.VisibleForTesting;
import com.ibm.icu.lang.UCharacter;
import java.util.regex.Pattern;

public class BidiUtils {
    private static final Pattern RtlLocalesRe = Pattern.compile("^(ar|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|.*[-_](Arab|Hebr|Thaa|Nkoo|Tfng))(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)", 2);
    public static final String RIGHT = "right";
    public static final String LEFT = "left";

    private BidiUtils() {
    }

    public static Dir languageDir(String languageString) {
        return BidiUtils.isRtlLanguage(languageString) ? Dir.RTL : Dir.LTR;
    }

    public static boolean isRtlLanguage(String languageString) {
        return languageString != null && RtlLocalesRe.matcher(languageString).find();
    }

    public static boolean hasAnyLtr(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).hasAnyLtr(false);
    }

    public static boolean hasAnyLtr(String str) {
        return BidiUtils.hasAnyLtr(str, false);
    }

    public static boolean hasAnyRtl(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).hasAnyRtl(false);
    }

    public static boolean hasAnyRtl(String str) {
        return BidiUtils.hasAnyRtl(str, false);
    }

    public static Dir getUnicodeDir(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).getUnicodeDir();
    }

    public static Dir getUnicodeDir(String str) {
        return BidiUtils.getUnicodeDir(str, false);
    }

    public static Dir getExitDir(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).getExitDir();
    }

    public static Dir getExitDir(String str) {
        return BidiUtils.getExitDir(str, false);
    }

    public static Dir estimateDirection(String str) {
        return BidiUtils.estimateDirection(str, false);
    }

    public static Dir estimateDirection(String str, boolean isHtml) {
        return new DirectionalityEstimator(str, isHtml).estimateDirectionByWordCount();
    }

    @VisibleForTesting
    static class DirectionalityEstimator {
        private static final int DIR_TYPE_CACHE_SIZE = 1792;
        private static final byte[] DIR_TYPE_CACHE = new byte[1792];
        private static final double RTL_THRESHOLD = 0.4;
        private final String text;
        private final boolean isHtml;
        private final int length;
        private int charIndex;
        private char lastChar;
        private int ltrWordCount;
        private int rtlWordCount;
        private int weakLtrWordCount;
        private int wordType;

        DirectionalityEstimator(String text, boolean isHtml) {
            this.text = text;
            this.isHtml = isHtml;
            this.length = text.length();
        }

        boolean hasAnyLtr(boolean countEmbedding) {
            this.charIndex = 0;
            int embeddingLevel = 0;
            while (this.charIndex < this.length) {
                switch (this.dirTypeForward()) {
                    case 0: {
                        if (embeddingLevel != 0) break;
                        return true;
                    }
                    case 11: 
                    case 12: {
                        if (!countEmbedding || embeddingLevel++ != 0) break;
                        return true;
                    }
                    case 14: 
                    case 15: {
                        if (!countEmbedding) break;
                        ++embeddingLevel;
                        break;
                    }
                    case 16: {
                        if (!countEmbedding) break;
                        --embeddingLevel;
                    }
                }
            }
            return false;
        }

        boolean hasAnyRtl(boolean countEmbedding) {
            this.charIndex = 0;
            int embeddingLevel = 0;
            while (this.charIndex < this.length) {
                switch (this.dirTypeForward()) {
                    case 1: 
                    case 13: {
                        if (embeddingLevel != 0) break;
                        return true;
                    }
                    case 14: 
                    case 15: {
                        if (!countEmbedding || embeddingLevel++ != 0) break;
                        return true;
                    }
                    case 11: 
                    case 12: {
                        if (!countEmbedding) break;
                        ++embeddingLevel;
                        break;
                    }
                    case 16: {
                        if (!countEmbedding) break;
                        --embeddingLevel;
                    }
                }
            }
            return false;
        }

        Dir getUnicodeDir() {
            this.charIndex = 0;
            while (this.charIndex < this.length) {
                switch (this.dirTypeForward()) {
                    case 0: {
                        return Dir.LTR;
                    }
                    case 1: 
                    case 13: {
                        return Dir.RTL;
                    }
                }
            }
            return Dir.UNKNOWN;
        }

        Dir getExitDir() {
            this.charIndex = this.length;
            int embeddingLevel = 0;
            int lastNonEmptyEmbeddingLevel = 0;
            block8: while (this.charIndex > 0) {
                switch (this.dirTypeBackward()) {
                    case 0: {
                        if (embeddingLevel == 0) {
                            return Dir.LTR;
                        }
                        if (lastNonEmptyEmbeddingLevel != 0) continue block8;
                        lastNonEmptyEmbeddingLevel = embeddingLevel;
                        continue block8;
                    }
                    case 11: 
                    case 12: {
                        if (lastNonEmptyEmbeddingLevel == embeddingLevel) {
                            return Dir.LTR;
                        }
                        --embeddingLevel;
                        continue block8;
                    }
                    case 1: 
                    case 13: {
                        if (embeddingLevel == 0) {
                            return Dir.RTL;
                        }
                        if (lastNonEmptyEmbeddingLevel != 0) continue block8;
                        lastNonEmptyEmbeddingLevel = embeddingLevel;
                        continue block8;
                    }
                    case 14: 
                    case 15: {
                        if (lastNonEmptyEmbeddingLevel == embeddingLevel) {
                            return Dir.RTL;
                        }
                        --embeddingLevel;
                        continue block8;
                    }
                    case 16: {
                        ++embeddingLevel;
                        continue block8;
                    }
                    case 18: {
                        continue block8;
                    }
                }
                if (lastNonEmptyEmbeddingLevel != 0) continue;
                lastNonEmptyEmbeddingLevel = embeddingLevel;
            }
            return Dir.UNKNOWN;
        }

        Dir estimateDirectionByWordCount() {
            this.charIndex = 0;
            this.ltrWordCount = 0;
            this.rtlWordCount = 0;
            this.weakLtrWordCount = 0;
            int embedLevel = 0;
            this.wordType = 0;
            block12: while (this.charIndex < this.length) {
                switch (this.dirTypeForward()) {
                    case 1: 
                    case 13: {
                        this.strongWord(true);
                        continue block12;
                    }
                    case 0: {
                        if (this.wordType == 0 && this.lastChar == 'h' && (this.matchForward("ttp://", true) || this.matchForward("ttps://", true))) {
                            this.wordType = 3;
                            ++this.weakLtrWordCount;
                            continue block12;
                        }
                        this.strongWord(false);
                        continue block12;
                    }
                    case 2: 
                    case 5: {
                        if (this.wordType >= 1) continue block12;
                        ++this.weakLtrWordCount;
                        this.wordType = 1;
                        continue block12;
                    }
                    case 8: 
                    case 9: {
                        if (this.wordType >= 4) continue block12;
                        this.wordType = 0;
                        continue block12;
                    }
                    case 7: {
                        embedLevel = 0;
                        this.wordType = 0;
                        continue block12;
                    }
                    case 12: {
                        this.strongWord(false);
                    }
                    case 11: {
                        if (embedLevel++ != 0) continue block12;
                        this.wordType = 4;
                        continue block12;
                    }
                    case 15: {
                        this.strongWord(true);
                    }
                    case 14: {
                        if (embedLevel++ != 0) continue block12;
                        this.wordType = 4;
                        continue block12;
                    }
                    case 16: {
                        if (--embedLevel != 0) continue block12;
                        this.wordType = 0;
                        continue block12;
                    }
                }
            }
            if ((double)this.rtlWordCount > (double)(this.ltrWordCount + this.rtlWordCount) * 0.4) {
                return Dir.RTL;
            }
            if (this.ltrWordCount + this.weakLtrWordCount > 0) {
                return Dir.LTR;
            }
            return Dir.UNKNOWN;
        }

        private void strongWord(boolean isRightToLeft) {
            if (this.wordType < 2) {
                if (isRightToLeft) {
                    ++this.rtlWordCount;
                } else {
                    ++this.ltrWordCount;
                }
                if (this.wordType == 1) {
                    --this.weakLtrWordCount;
                }
                this.wordType = 2;
            }
        }

        @VisibleForTesting
        boolean matchForward(String match, boolean advance) {
            int matchLength = match.length();
            if (matchLength > this.length - this.charIndex) {
                return false;
            }
            for (int checkIndex = 0; checkIndex < matchLength; ++checkIndex) {
                if (this.text.charAt(this.charIndex + checkIndex) == match.charAt(checkIndex)) continue;
                return false;
            }
            if (advance) {
                this.charIndex += matchLength;
            }
            return true;
        }

        private static byte getCachedDirectionality(char c) {
            return c < '\u0700' ? DIR_TYPE_CACHE[c] : UCharacter.getDirectionality((int)c);
        }

        @VisibleForTesting
        byte dirTypeForward() {
            this.lastChar = this.text.charAt(this.charIndex);
            if (UCharacter.isHighSurrogate((char)this.lastChar)) {
                int codePoint = UCharacter.codePointAt((CharSequence)this.text, (int)this.charIndex);
                this.charIndex += UCharacter.charCount((int)codePoint);
                return UCharacter.getDirectionality((int)codePoint);
            }
            ++this.charIndex;
            byte dirType = DirectionalityEstimator.getCachedDirectionality(this.lastChar);
            if (this.isHtml) {
                if (this.lastChar == '<') {
                    dirType = this.skipTagForward();
                } else if (this.lastChar == '&') {
                    dirType = this.skipEntityForward();
                }
            }
            return dirType;
        }

        @VisibleForTesting
        byte dirTypeBackward() {
            this.lastChar = this.text.charAt(this.charIndex - 1);
            if (UCharacter.isLowSurrogate((char)this.lastChar)) {
                int codePoint = UCharacter.codePointBefore((CharSequence)this.text, (int)this.charIndex);
                this.charIndex -= UCharacter.charCount((int)codePoint);
                return UCharacter.getDirectionality((int)codePoint);
            }
            --this.charIndex;
            byte dirType = DirectionalityEstimator.getCachedDirectionality(this.lastChar);
            if (this.isHtml) {
                if (this.lastChar == '>') {
                    dirType = this.skipTagBackward();
                } else if (this.lastChar == ';') {
                    dirType = this.skipEntityBackward();
                }
            }
            return dirType;
        }

        private byte skipTagForward() {
            int initialCharIndex = this.charIndex;
            while (this.charIndex < this.length) {
                this.lastChar = this.text.charAt(this.charIndex++);
                if (this.lastChar == '>') {
                    return 9;
                }
                if (this.lastChar != '\"' && this.lastChar != '\'') continue;
                char quote = this.lastChar;
                while (this.charIndex < this.length && (this.lastChar = this.text.charAt(this.charIndex++)) != quote) {
                }
            }
            this.charIndex = initialCharIndex;
            this.lastChar = (char)60;
            return 10;
        }

        private byte skipTagBackward() {
            int initialCharIndex = this.charIndex;
            while (this.charIndex > 0) {
                this.lastChar = this.text.charAt(--this.charIndex);
                if (this.lastChar == '<') {
                    return 9;
                }
                if (this.lastChar == '>') break;
                if (this.lastChar != '\"' && this.lastChar != '\'') continue;
                char quote = this.lastChar;
                while (this.charIndex > 0 && (this.lastChar = this.text.charAt(--this.charIndex)) != quote) {
                }
            }
            this.charIndex = initialCharIndex;
            this.lastChar = (char)62;
            return 10;
        }

        private byte skipEntityForward() {
            while (this.charIndex < this.length && (this.lastChar = this.text.charAt(this.charIndex++)) != ';') {
            }
            return 9;
        }

        private byte skipEntityBackward() {
            int initialCharIndex = this.charIndex;
            while (this.charIndex > 0) {
                this.lastChar = this.text.charAt(--this.charIndex);
                if (this.lastChar == '&') {
                    return 9;
                }
                if (this.lastChar != ';') continue;
            }
            this.charIndex = initialCharIndex;
            this.lastChar = (char)59;
            return 10;
        }

        static {
            for (int i = 0; i < 1792; ++i) {
                DirectionalityEstimator.DIR_TYPE_CACHE[i] = UCharacter.getDirectionality((int)i);
            }
        }

        private static class WordType {
            public static final int NEUTRAL = 0;
            public static final int NUMERIC = 1;
            public static final int STRONG = 2;
            public static final int URL = 3;
            public static final int EMBEDDED = 4;

            private WordType() {
            }
        }
    }

    public static final class Format {
        public static final char LRE = '\u202a';
        public static final char RLE = '\u202b';
        public static final char PDF = '\u202c';
        public static final char LRM = '\u200e';
        public static final char RLM = '\u200f';
        public static final String LRM_STRING = Character.toString('\u200e');
        public static final String RLM_STRING = Character.toString('\u200f');

        private Format() {
        }
    }

    public static enum Dir {
        LTR(1),
        UNKNOWN(0),
        RTL(-1);

        public final int ord;

        private Dir(int ord) {
            this.ord = ord;
        }

        public static Dir valueOf(int dir) {
            return dir > 0 ? LTR : (dir < 0 ? RTL : UNKNOWN);
        }

        public static Dir valueOf(boolean dir) {
            return dir ? RTL : LTR;
        }

        public boolean isOppositeTo(Dir dir) {
            return this.ord * dir.ord < 0;
        }
    }
}

