/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.i18ndirectives;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.i18ndirectives.I18nUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.shared.restricted.SoyJavaRuntimeFunctionUtils;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuPrintDirective;
import com.ibm.icu.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Set;

class FormatNumDirective
extends SoyAbstractTofuPrintDirective
implements SoyJsSrcPrintDirective {
    private Provider<String> localeStringProvider;

    @Inject
    FormatNumDirective(@ApiCallScopeBindingAnnotations.LocaleString Provider<String> localeStringProvider) {
        this.localeStringProvider = localeStringProvider;
    }

    @Override
    public String getName() {
        return "|formatNum";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return false;
    }

    @Override
    public SoyData apply(SoyData value, List<SoyData> args) {
        NumberFormat instance;
        String formatType;
        Locale locale = I18nUtils.parseLocale((String)this.localeStringProvider.get());
        String string = formatType = args.isEmpty() ? "decimal" : args.get(0).stringValue();
        if (formatType == "decimal") {
            instance = NumberFormat.getInstance((Locale)locale);
        } else if (formatType == "percent") {
            instance = NumberFormat.getPercentInstance((Locale)locale);
        } else if (formatType == "currency") {
            instance = NumberFormat.getCurrencyInstance((Locale)locale);
        } else if (formatType == "scientific") {
            instance = NumberFormat.getScientificInstance((Locale)locale);
        } else {
            throw new IllegalArgumentException(String.format("Unrecognized Number Format Type: {0}", formatType));
        }
        return SoyJavaRuntimeFunctionUtils.toSoyData(instance.format(((NumberData)value).toFloat()));
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        String numberFormatNameJsExprText = args.isEmpty() ? "'DECIMAL'" : "(" + args.get(0).getText() + ").toUpperCase()";
        String numberFormatDecl = "goog.i18n.NumberFormat.Format[" + numberFormatNameJsExprText + "]";
        return new JsExpr("(new goog.i18n.NumberFormat(" + numberFormatDecl + ")).format(" + value.getText() + ")", Integer.MAX_VALUE);
    }
}

