/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;

public class DataRefNode
extends AbstractParentExprNode {
    private final boolean isIjDataRef;
    private final boolean isNullSafeIjDataRef;
    private Boolean isLocalVarDataRef;
    private final String firstKey;

    public DataRefNode(boolean isIjDataRef, boolean isNullSafeIjDataRef, String firstKey) {
        this.isIjDataRef = isIjDataRef;
        this.isNullSafeIjDataRef = isNullSafeIjDataRef;
        this.isLocalVarDataRef = null;
        this.firstKey = firstKey;
    }

    protected DataRefNode(DataRefNode orig) {
        super(orig);
        this.isIjDataRef = orig.isIjDataRef;
        this.isNullSafeIjDataRef = orig.isNullSafeIjDataRef;
        this.isLocalVarDataRef = orig.isLocalVarDataRef;
        this.firstKey = orig.firstKey;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.DATA_REF_NODE;
    }

    public boolean isIjDataRef() {
        return this.isIjDataRef;
    }

    public boolean isNullSafeIjDataRef() {
        return this.isNullSafeIjDataRef;
    }

    public void setIsLocalVarDataRef(Boolean isLocalVarDataRef) {
        this.isLocalVarDataRef = isLocalVarDataRef;
    }

    public Boolean isLocalVarDataRef() {
        return this.isLocalVarDataRef;
    }

    public String getFirstKey() {
        return this.firstKey;
    }

    @Override
    public String toSourceString() {
        StringBuilder sourceSb = new StringBuilder();
        sourceSb.append(this.isNullSafeIjDataRef ? "$ij?." : (this.isIjDataRef ? "$ij." : "$"));
        sourceSb.append(this.firstKey);
        for (ExprNode child : this.getChildren()) {
            sourceSb.append(child.toSourceString());
        }
        return sourceSb.toString();
    }

    @Override
    public DataRefNode clone() {
        return new DataRefNode(this);
    }
}

