/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internalutils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.SanitizedContent;
import java.util.EnumSet;
import java.util.Set;

public class NodeContentKinds {
    private static final ImmutableBiMap<String, SanitizedContent.ContentKind> KIND_ATTRIBUTE_TO_SANITIZED_CONTENT_KIND_BI_MAP = ImmutableBiMap.builder().put((Object)"attributes", (Object)SanitizedContent.ContentKind.ATTRIBUTES).put((Object)"css", (Object)SanitizedContent.ContentKind.CSS).put((Object)"html", (Object)SanitizedContent.ContentKind.HTML).put((Object)"js", (Object)SanitizedContent.ContentKind.JS).put((Object)"text", (Object)SanitizedContent.ContentKind.TEXT).put((Object)"uri", (Object)SanitizedContent.ContentKind.URI).build();
    private static final ImmutableMap<SanitizedContent.ContentKind, String> KIND_TO_JS_TYPE_NAME = ImmutableMap.builder().put((Object)SanitizedContent.ContentKind.HTML, (Object)"soydata.SanitizedHtml").put((Object)SanitizedContent.ContentKind.ATTRIBUTES, (Object)"soydata.SanitizedHtmlAttribute").put((Object)SanitizedContent.ContentKind.JS, (Object)"soydata.SanitizedJs").put((Object)SanitizedContent.ContentKind.JS_STR_CHARS, (Object)"soydata.SanitizedJsStrChars").put((Object)SanitizedContent.ContentKind.URI, (Object)"soydata.SanitizedUri").put((Object)SanitizedContent.ContentKind.CSS, (Object)"soydata.SanitizedCss").put((Object)SanitizedContent.ContentKind.TEXT, (Object)"soydata.UnsanitizedText").build();
    private static final ImmutableMap<SanitizedContent.ContentKind, String> KIND_TO_JS_ORDAINER_NAME = ImmutableMap.builder().put((Object)SanitizedContent.ContentKind.HTML, (Object)"soydata.VERY_UNSAFE.ordainSanitizedHtml").put((Object)SanitizedContent.ContentKind.ATTRIBUTES, (Object)"soydata.VERY_UNSAFE.ordainSanitizedHtmlAttribute").put((Object)SanitizedContent.ContentKind.JS, (Object)"soydata.VERY_UNSAFE.ordainSanitizedJs").put((Object)SanitizedContent.ContentKind.JS_STR_CHARS, (Object)"soydata.VERY_UNSAFE.ordainSanitizedJsStrChars").put((Object)SanitizedContent.ContentKind.URI, (Object)"soydata.VERY_UNSAFE.ordainSanitizedUri").put((Object)SanitizedContent.ContentKind.CSS, (Object)"soydata.VERY_UNSAFE.ordainSanitizedCss").put((Object)SanitizedContent.ContentKind.TEXT, (Object)"soydata.markUnsanitizedText").build();

    public static SanitizedContent.ContentKind forAttributeValue(String attributeValue) {
        return (SanitizedContent.ContentKind)((Object)KIND_ATTRIBUTE_TO_SANITIZED_CONTENT_KIND_BI_MAP.get((Object)attributeValue));
    }

    public static String toAttributeValue(SanitizedContent.ContentKind kind) {
        return (String)KIND_ATTRIBUTE_TO_SANITIZED_CONTENT_KIND_BI_MAP.inverse().get((Object)kind);
    }

    public static Set<String> getAttributeValues() {
        return KIND_ATTRIBUTE_TO_SANITIZED_CONTENT_KIND_BI_MAP.keySet();
    }

    public static String toJsSanitizedContentTypeName(SanitizedContent.ContentKind contentKind) {
        return (String)Preconditions.checkNotNull((Object)KIND_TO_JS_TYPE_NAME.get((Object)contentKind));
    }

    public static String toJsSanitizedContentOrdainer(SanitizedContent.ContentKind contentKind) {
        return (String)Preconditions.checkNotNull((Object)KIND_TO_JS_ORDAINER_NAME.get((Object)contentKind));
    }

    private NodeContentKinds() {
    }

    static {
        if (!KIND_TO_JS_TYPE_NAME.keySet().containsAll(EnumSet.allOf(SanitizedContent.ContentKind.class))) {
            throw new AssertionError((Object)"Not all ContentKind enums have a JS constructor");
        }
        if (!KIND_TO_JS_ORDAINER_NAME.keySet().containsAll(EnumSet.allOf(SanitizedContent.ContentKind.class))) {
            throw new AssertionError((Object)"Not all ContentKind enums have a JS ordainer");
        }
    }
}

