/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AugmentedSoyMapData
extends SoyMapData {
    private final SoyMapData baseData;

    public AugmentedSoyMapData(SoyMapData baseData) {
        Preconditions.checkNotNull((Object)baseData);
        this.baseData = baseData;
    }

    @Override
    public Map<String, SoyData> asMap() {
        SoyMapData combinedMapData = new SoyMapData();
        AugmentedSoyMapData.addMapDataHelper(combinedMapData, "", this.baseData.asMap());
        AugmentedSoyMapData.addMapDataHelper(combinedMapData, "", super.asMap());
        return Collections.unmodifiableMap(combinedMapData.asMap());
    }

    private static void addMapDataHelper(SoyMapData combinedMapData, String keyPrefix, Map<String, SoyData> map) {
        for (Map.Entry<String, SoyData> entry : map.entrySet()) {
            String key = entry.getKey();
            SoyData value = entry.getValue();
            if (value instanceof SoyMapData) {
                AugmentedSoyMapData.addMapDataHelper(combinedMapData, keyPrefix + key + ".", ((SoyMapData)value).asMap());
                continue;
            }
            if (value instanceof SoyListData) {
                AugmentedSoyMapData.addListDataHelper(combinedMapData, keyPrefix + key + ".", ((SoyListData)value).asList());
                continue;
            }
            combinedMapData.put(keyPrefix + key, value);
        }
    }

    private static void addListDataHelper(SoyMapData combinedMapData, String keyPrefix, List<SoyData> list) {
        for (int i = 0; i < list.size(); ++i) {
            SoyData el = list.get(i);
            if (el instanceof SoyMapData) {
                AugmentedSoyMapData.addMapDataHelper(combinedMapData, keyPrefix + i + ".", ((SoyMapData)el).asMap());
                continue;
            }
            if (el instanceof SoyListData) {
                AugmentedSoyMapData.addListDataHelper(combinedMapData, keyPrefix + i + ".", ((SoyListData)el).asList());
                continue;
            }
            combinedMapData.put(keyPrefix + i, el);
        }
    }

    @Override
    public Set<String> getKeys() {
        return Collections.unmodifiableSet(Sets.union(super.getKeys(), this.baseData.getKeys()));
    }

    @Override
    public String toString() {
        return this.toStringHelper(this.asMap());
    }

    @Override
    public boolean toBoolean() {
        return true;
    }

    @Override
    public void put(String keyStr, SoyData value) {
        if (keyStr.indexOf(46) >= 0) {
            throw new SoyDataException("Attempted to put multi-part key string into AugmentedSoyMapData. Please ensure that all of your 'param' commands only use top-level keys.");
        }
        super.putSingle(keyStr, value);
    }

    @Override
    public void remove(String keyStr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSingle(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SoyData getSingle(String key) {
        SoyData value = super.getSingle(key);
        if (value != null) {
            return value;
        }
        return this.baseData.getSingle(key);
    }
}

