/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.CollectionData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SoyListData
extends CollectionData
implements Iterable<SoyData> {
    private final List<SoyData> list = Lists.newArrayList();

    public SoyListData() {
    }

    public SoyListData(Iterable<?> data) {
        this();
        this.add(data);
    }

    public SoyListData(Object ... values) {
        this(Arrays.asList(values));
    }

    public List<SoyData> asList() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public String toString() {
        return "[" + Joiner.on((String)", ").join(this.list) + "]";
    }

    @Override
    public boolean toBoolean() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    public int length() {
        return this.list.size();
    }

    @Override
    public Iterator<SoyData> iterator() {
        return Collections.unmodifiableList(this.list).iterator();
    }

    private void add(Iterable<?> data) {
        for (Object el : data) {
            try {
                this.add(SoyData.createFromExistingData(el));
            }
            catch (SoyDataException sde) {
                sde.prependIndexToDataPath(this.list.size());
                throw sde;
            }
        }
    }

    public void add(Object ... values) {
        this.add(Arrays.asList(values));
    }

    public void add(SoyData value) {
        this.list.add(SoyListData.ensureValidValue(value));
    }

    public void add(boolean value) {
        this.add(BooleanData.forValue(value));
    }

    public void add(int value) {
        this.add(IntegerData.forValue(value));
    }

    public void add(double value) {
        this.add(FloatData.forValue(value));
    }

    public void add(String value) {
        this.add(StringData.forValue(value));
    }

    public void set(int index, SoyData value) {
        if (index == this.list.size()) {
            this.list.add(SoyListData.ensureValidValue(value));
        } else {
            this.list.set(index, SoyListData.ensureValidValue(value));
        }
    }

    public void set(int index, boolean value) {
        this.set(index, BooleanData.forValue(value));
    }

    public void set(int index, int value) {
        this.set(index, IntegerData.forValue(value));
    }

    public void set(int index, double value) {
        this.set(index, FloatData.forValue(value));
    }

    public void set(int index, String value) {
        this.set(index, StringData.forValue(value));
    }

    public void remove(int index) {
        this.list.remove(index);
    }

    public SoyData get(int index) {
        try {
            return this.list.get(index);
        }
        catch (IndexOutOfBoundsException ioobe) {
            return null;
        }
    }

    public SoyMapData getMapData(int index) {
        return (SoyMapData)this.get(index);
    }

    public SoyListData getListData(int index) {
        return (SoyListData)this.get(index);
    }

    public boolean getBoolean(int index) {
        return this.get(index).booleanValue();
    }

    public int getInteger(int index) {
        return this.get(index).integerValue();
    }

    public double getFloat(int index) {
        return this.get(index).floatValue();
    }

    public String getString(int index) {
        return this.get(index).stringValue();
    }

    @Override
    public void putSingle(String key, SoyData value) {
        this.set(Integer.parseInt(key), value);
    }

    @Override
    public void removeSingle(String key) {
        this.remove(Integer.parseInt(key));
    }

    @Override
    public SoyData getSingle(String key) {
        return this.get(Integer.parseInt(key));
    }
}

