/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import java.util.Map;

public abstract class SoyData {
    public static SoyData createFromExistingData(Object obj) {
        if (obj == null) {
            return NullData.INSTANCE;
        }
        if (obj instanceof SoyData) {
            return (SoyData)obj;
        }
        if (obj instanceof String) {
            return StringData.forValue((String)obj);
        }
        if (obj instanceof Boolean) {
            return BooleanData.forValue((Boolean)obj);
        }
        if (obj instanceof Integer) {
            return IntegerData.forValue((Integer)obj);
        }
        if (obj instanceof Map) {
            Map objCast = (Map)obj;
            return new SoyMapData(objCast);
        }
        if (obj instanceof Iterable) {
            return new SoyListData((Iterable)obj);
        }
        if (obj instanceof Double) {
            return FloatData.forValue((Double)obj);
        }
        if (obj instanceof Float) {
            return FloatData.forValue(((Float)obj).floatValue());
        }
        throw new SoyDataException("Attempting to convert unrecognized object to Soy data (object type " + obj.getClass().getName() + ").");
    }

    public static SoyData createFromExistingData(String str) {
        if (str == null) {
            return NullData.INSTANCE;
        }
        return StringData.forValue(str);
    }

    public abstract String toString();

    public abstract boolean toBoolean();

    public abstract boolean equals(Object var1);

    public boolean booleanValue() {
        throw new SoyDataException("Expecting boolean value but instead encountered type " + this.getClass().getSimpleName());
    }

    public int integerValue() {
        throw new SoyDataException("Expecting integer value but instead encountered type " + this.getClass().getSimpleName());
    }

    public double floatValue() {
        throw new SoyDataException("Expecting float value but instead encountered type " + this.getClass().getSimpleName());
    }

    public double numberValue() {
        throw new SoyDataException("Expecting number value but instead encountered type " + this.getClass().getSimpleName());
    }

    public String stringValue() {
        throw new SoyDataException("Expecting string value but instead encountered type " + this.getClass().getSimpleName());
    }
}

