/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import com.google.template.soy.data.SanitizedContent;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class SanitizedContents {
    private SanitizedContents() {
    }

    public static SanitizedContent emptyString(SanitizedContent.ContentKind kind) throws IOException {
        return new SanitizedContent("", kind);
    }

    public static SanitizedContent fromResource(Class<?> contextClass, String resourceName, Charset charset, SanitizedContent.ContentKind kind) throws IOException {
        SanitizedContents.pretendValidateResource(resourceName, kind);
        return new SanitizedContent(Resources.toString((URL)Resources.getResource(contextClass, (String)resourceName), (Charset)charset), kind);
    }

    @VisibleForTesting
    static void pretendValidateResource(String resourceName, SanitizedContent.ContentKind kind) {
        int index = resourceName.lastIndexOf(46);
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"Currently, we only validate resources with explicit extensions.");
        String fileExtension = resourceName.substring(index + 1).toLowerCase();
        switch (kind) {
            case JS: {
                Preconditions.checkArgument((boolean)fileExtension.equals("js"));
                break;
            }
            case HTML: {
                Preconditions.checkArgument((boolean)fileExtension.equals("html"));
                break;
            }
            case CSS: {
                Preconditions.checkArgument((boolean)fileExtension.equals("css"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't know how to validate resources of kind " + (Object)((Object)kind));
            }
        }
    }
}

