/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bidifunctions;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunctionUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaRuntimeFunctionUtils;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuFunction;
import java.util.List;
import java.util.Set;

@Singleton
class BidiStartEdgeFunction
extends SoyAbstractTofuFunction
implements SoyJsSrcFunction,
SoyJavaSrcFunction {
    private final Provider<BidiGlobalDir> bidiGlobalDirProvider;

    @Inject
    BidiStartEdgeFunction(Provider<BidiGlobalDir> bidiGlobalDirProvider) {
        this.bidiGlobalDirProvider = bidiGlobalDirProvider;
    }

    @Override
    public String getName() {
        return "bidiStartEdge";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public SoyData compute(List<SoyData> args) {
        return SoyJavaRuntimeFunctionUtils.toSoyData(((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getStaticValue() < 0 ? "right" : "left");
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        BidiGlobalDir bidiGlobalDir = (BidiGlobalDir)this.bidiGlobalDirProvider.get();
        if (bidiGlobalDir.isStaticValue()) {
            return new JsExpr(bidiGlobalDir.getStaticValue() < 0 ? "'right'" : "'left'", Integer.MAX_VALUE);
        }
        return new JsExpr("(" + bidiGlobalDir.getCodeSnippet() + ") < 0 ? 'right' : 'left'", Operator.CONDITIONAL.getPrecedence());
    }

    @Override
    public JavaExpr computeForJavaSrc(List<JavaExpr> args) {
        BidiGlobalDir bidiGlobalDir = (BidiGlobalDir)this.bidiGlobalDirProvider.get();
        if (bidiGlobalDir.isStaticValue()) {
            return SoyJavaSrcFunctionUtils.toStringJavaExpr(JavaCodeUtils.genNewStringData(bidiGlobalDir.getStaticValue() < 0 ? "\"right\"" : "\"left\""));
        }
        String bidiFunctionName = SoyBidiUtils.class.getName() + ".getBidiFormatter(" + bidiGlobalDir.getCodeSnippet() + ").startEdge";
        return SoyJavaSrcFunctionUtils.toStringJavaExpr(JavaCodeUtils.genNewStringData(JavaCodeUtils.genFunctionCall(bidiFunctionName, new String[0])));
    }
}

