/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bididirectives;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunctionUtils;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuPrintDirective;
import java.util.List;
import java.util.Set;

@Singleton
public class BidiUnicodeWrapDirective
extends SoyAbstractTofuPrintDirective
implements SoyJsSrcPrintDirective,
SoyJavaSrcPrintDirective {
    private final Provider<BidiGlobalDir> bidiGlobalDirProvider;

    @Inject
    BidiUnicodeWrapDirective(Provider<BidiGlobalDir> bidiGlobalDirProvider) {
        this.bidiGlobalDirProvider = bidiGlobalDirProvider;
    }

    @Override
    public String getName() {
        return "|bidiUnicodeWrap";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return false;
    }

    @Override
    public SoyData apply(SoyData value, List<SoyData> args) {
        String str = SoyBidiUtils.getBidiFormatter(((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getStaticValue()).unicodeWrap(value.toString(), true);
        return SoyData.createFromExistingData(str);
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        String codeSnippet = ((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getCodeSnippet();
        return new JsExpr("soy.$$bidiUnicodeWrap(" + codeSnippet + ", " + value.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr applyForJavaSrc(JavaExpr value, List<JavaExpr> args) {
        String bidiFunctionName = SoyBidiUtils.class.getName() + ".getBidiFormatter(" + ((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getCodeSnippet() + ").unicodeWrap";
        return SoyJavaSrcFunctionUtils.toStringJavaExpr(JavaCodeUtils.genNewStringData(JavaCodeUtils.genFunctionCall(bidiFunctionName, JavaCodeUtils.genCoerceString(value), "true")));
    }
}

