/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunctionUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaRuntimeFunctionUtils;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuFunction;
import java.util.List;
import java.util.Set;

@Singleton
@SoyPureFunction
class StrContainsFunction
extends SoyAbstractTofuFunction
implements SoyJsSrcFunction,
SoyJavaSrcFunction {
    @Inject
    StrContainsFunction() {
    }

    @Override
    public String getName() {
        return "strContains";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)2);
    }

    @Override
    public SoyData compute(List<SoyData> args) {
        SoyData arg0 = args.get(0);
        SoyData arg1 = args.get(1);
        Preconditions.checkArgument((boolean)(arg0 instanceof StringData), (Object)String.format("First argument to strContains() function is not StringData: %s", arg0.stringValue()));
        Preconditions.checkArgument((boolean)(arg1 instanceof StringData), (Object)String.format("Second argument to strContains() function is not StringData: %s", arg1.stringValue()));
        String strArg0 = arg0.stringValue();
        String strArg1 = arg1.stringValue();
        return SoyJavaRuntimeFunctionUtils.toSoyData(strArg0.contains(strArg1));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        JsExpr arg0 = args.get(0);
        JsExpr arg1 = args.get(1);
        String arg0Text = arg0.getPrecedence() == Integer.MAX_VALUE ? arg0.getText() : "(" + arg0.getText() + ")";
        String arg1Text = arg1.getText();
        String exprText = arg0Text + ".indexOf(" + arg1Text + ") != -1";
        return new JsExpr(exprText, Operator.NOT_EQUAL.getPrecedence());
    }

    @Override
    public JavaExpr computeForJavaSrc(List<JavaExpr> args) {
        JavaExpr arg0 = args.get(0);
        JavaExpr arg1 = args.get(1);
        return SoyJavaSrcFunctionUtils.toBooleanJavaExpr(JavaCodeUtils.genNewBooleanData("(" + arg0.getText() + ").contains(" + arg1.getText() + ")"));
    }
}

