/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicdirectives;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuPrintDirective;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TruncateDirective
extends SoyAbstractTofuPrintDirective
implements SoyJsSrcPrintDirective,
SoyJavaSrcPrintDirective {
    @Inject
    public TruncateDirective() {
    }

    @Override
    public String getName() {
        return "|truncate";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1, (Object)2);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return false;
    }

    @Override
    public SoyData apply(SoyData value, List<SoyData> args) {
        boolean doAddEllipsis;
        int maxLen;
        try {
            maxLen = args.get(0).integerValue();
        }
        catch (SoyDataException sde) {
            throw new IllegalArgumentException("Could not parse first parameter of '|truncate' as integer (value was \"" + args.get(0).stringValue() + "\").");
        }
        String str = value.toString();
        if (str.length() <= maxLen) {
            return SoyData.createFromExistingData(str);
        }
        if (args.size() == 2) {
            try {
                doAddEllipsis = args.get(1).booleanValue();
            }
            catch (SoyDataException sde) {
                throw new IllegalArgumentException("Could not parse second parameter of '|truncate' as boolean.");
            }
        } else {
            doAddEllipsis = true;
        }
        if (doAddEllipsis) {
            if (maxLen > 3) {
                maxLen -= 3;
            } else {
                doAddEllipsis = false;
            }
        }
        if (Character.isHighSurrogate(str.charAt(maxLen - 1)) && Character.isLowSurrogate(str.charAt(maxLen))) {
            --maxLen;
        }
        str = str.substring(0, maxLen);
        if (doAddEllipsis) {
            str = str + "...";
        }
        return SoyData.createFromExistingData(str);
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        String maxLenExprText = args.get(0).getText();
        String doAddEllipsisExprText = args.size() == 2 ? args.get(1).getText() : "true";
        return new JsExpr("soy.$$truncate(" + value.getText() + ", " + maxLenExprText + ", " + doAddEllipsisExprText + ")", Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr applyForJavaSrc(JavaExpr value, List<JavaExpr> args) {
        String valueExprText = JavaCodeUtils.genCoerceString(value);
        String maxLenExprText = JavaCodeUtils.genIntegerValue(args.get(0));
        String doAddEllipsisExprText = args.size() == 2 ? JavaCodeUtils.genBooleanValue(args.get(1)) : "true";
        return new JavaExpr(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$truncate", valueExprText, maxLenExprText, doAddEllipsisExprText), String.class, Integer.MAX_VALUE);
    }
}

