/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicdirectives;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContentOperator;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuPrintDirective;
import java.util.List;
import java.util.Set;

@Singleton
public class InsertWordBreaksDirective
extends SoyAbstractTofuPrintDirective
implements SoyJsSrcPrintDirective,
SoyJavaSrcPrintDirective,
SanitizedContentOperator {
    @Inject
    InsertWordBreaksDirective() {
    }

    @Override
    public String getName() {
        return "|insertWordBreaks";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return false;
    }

    @Override
    public SoyData apply(SoyData value, List<SoyData> args) {
        int codePoint;
        int maxCharsBetweenWordBreaks;
        try {
            maxCharsBetweenWordBreaks = args.get(0).integerValue();
        }
        catch (SoyDataException sde) {
            throw new IllegalArgumentException("Could not parse 'insertWordBreaks' parameter as integer.");
        }
        StringBuilder result = new StringBuilder();
        boolean isInTag = false;
        boolean isMaybeInEntity = false;
        int numCharsWithoutBreak = 0;
        String str = value.toString();
        int n = str.length();
        for (int i = 0; i < n; i += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(i);
            if (numCharsWithoutBreak >= maxCharsBetweenWordBreaks && codePoint != 32) {
                result.append("<wbr>");
                numCharsWithoutBreak = 0;
            }
            if (isInTag) {
                if (codePoint == 62) {
                    isInTag = false;
                }
            } else if (isMaybeInEntity) {
                switch (codePoint) {
                    case 59: {
                        isMaybeInEntity = false;
                        ++numCharsWithoutBreak;
                        break;
                    }
                    case 60: {
                        isMaybeInEntity = false;
                        isInTag = true;
                        break;
                    }
                    case 32: {
                        isMaybeInEntity = false;
                        numCharsWithoutBreak = 0;
                    }
                }
            } else {
                switch (codePoint) {
                    case 60: {
                        isInTag = true;
                        break;
                    }
                    case 38: {
                        isMaybeInEntity = true;
                        break;
                    }
                    case 32: {
                        numCharsWithoutBreak = 0;
                        break;
                    }
                    default: {
                        ++numCharsWithoutBreak;
                    }
                }
            }
            result.appendCodePoint(codePoint);
        }
        return SoyData.createFromExistingData(result.toString());
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        return new JsExpr("soy.$$insertWordBreaks(" + value.getText() + ", " + args.get(0).getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr applyForJavaSrc(JavaExpr value, List<JavaExpr> args) {
        return new JavaExpr(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$insertWordBreaks", JavaCodeUtils.genCoerceString(value), JavaCodeUtils.genIntegerValue(args.get(0))), String.class, Integer.MAX_VALUE);
    }

    @Override
    public SanitizedContent.ContentKind getContentKind() {
        return SanitizedContent.ContentKind.HTML;
    }
}

