/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import com.google.template.soy.base.SoyFileKind;
import com.google.template.soy.base.StableSoyFileSupplier;
import com.google.template.soy.internal.base.Pair;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;

public interface SoyFileSupplier {
    public Pair<Reader, Version> open() throws IOException;

    public boolean hasChangedSince(Version var1);

    public SoyFileKind getSoyFileKind();

    public String getFilePath();

    public static final class Factory {
        public static SoyFileSupplier create(InputSupplier<? extends Reader> contentSupplier, SoyFileKind soyFileKind, String filePath) {
            return new StableSoyFileSupplier(contentSupplier, soyFileKind, filePath);
        }

        public static SoyFileSupplier create(File inputFile, SoyFileKind soyFileKind) {
            return Factory.create((InputSupplier<? extends Reader>)Files.newReaderSupplier((File)inputFile, (Charset)Charsets.UTF_8), soyFileKind, inputFile.getPath());
        }

        public static SoyFileSupplier create(URL inputFileUrl, SoyFileKind soyFileKind, String filePath) {
            return Factory.create((InputSupplier<? extends Reader>)Resources.newReaderSupplier((URL)inputFileUrl, (Charset)Charsets.UTF_8), soyFileKind, filePath);
        }

        public static SoyFileSupplier create(URL inputFileUrl, SoyFileKind soyFileKind) {
            return Factory.create(inputFileUrl, soyFileKind, inputFileUrl.toString());
        }

        public static SoyFileSupplier create(CharSequence content, SoyFileKind soyFileKind, String filePath) {
            return Factory.create((InputSupplier<? extends Reader>)CharStreams.newReaderSupplier((String)((Object)content).toString()), soyFileKind, filePath);
        }

        private Factory() {
        }
    }

    public static interface Version {
        public static final Version STABLE_VERSION = new Version(){};

        public boolean equals(Object var1);
    }
}

