/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class SourceLocation {
    @Nonnull
    private final String filePath;
    private final int lineNumber;
    public static final SourceLocation UNKNOWN = new SourceLocation("unknown", 0);

    public SourceLocation(String filePath, int lineNumber) {
        int lastBangIndex = filePath.lastIndexOf(33);
        if (lastBangIndex != -1) {
            filePath = filePath.substring(lastBangIndex + 1);
        }
        this.filePath = filePath;
        this.lineNumber = lineNumber;
    }

    @Nonnull
    public String getFilePath() {
        return this.filePath;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean isKnown() {
        return !this.equals(UNKNOWN);
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof SourceLocation)) {
            return false;
        }
        SourceLocation that = (SourceLocation)o;
        return this.filePath.equals(that.filePath) && this.lineNumber == that.lineNumber;
    }

    public int hashCode() {
        return this.filePath.hashCode() + 31 * this.lineNumber;
    }

    public String toString() {
        return this.lineNumber != 0 ? this.filePath + ":" + this.lineNumber : this.filePath;
    }
}

