/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.InputSupplier;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.util.Providers;
import com.google.template.soy.GuiceInitializer;
import com.google.template.soy.base.SoyFileKind;
import com.google.template.soy.base.SoyFileSupplier;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.base.VolatileSoyFileSupplier;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.javasrc.SoyTemplateRuntime;
import com.google.template.soy.javasrc.SoyTemplateRuntimes;
import com.google.template.soy.javasrc.dyncompile.SoyToJavaDynamicCompiler;
import com.google.template.soy.javasrc.internal.JavaSrcMain;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.JsSrcMain;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.msgs.internal.ExtractMsgsVisitor;
import com.google.template.soy.parseinfo.passes.GenerateParseInfoVisitor;
import com.google.template.soy.parsepasses.ChangeCallsToPassAllDataVisitor;
import com.google.template.soy.parsepasses.CheckFunctionCallsVisitor;
import com.google.template.soy.parsepasses.HandleCssCommandVisitor;
import com.google.template.soy.parsepasses.PerformAutoescapeVisitor;
import com.google.template.soy.parsepasses.contextautoesc.CheckEscapingSanityVisitor;
import com.google.template.soy.parsepasses.contextautoesc.ContextualAutoescaper;
import com.google.template.soy.parsepasses.contextautoesc.DerivedTemplateUtils;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.sharedpasses.AssertNoExternalCallsVisitor;
import com.google.template.soy.sharedpasses.ClearSoyDocStringsVisitor;
import com.google.template.soy.sharedpasses.SubstituteGlobalsVisitor;
import com.google.template.soy.sharedpasses.opti.SimplifyVisitor;
import com.google.template.soy.soyparse.SoyFileSetParser;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.SoyTofuOptions;
import com.google.template.soy.tofu.internal.BaseTofu;
import com.google.template.soy.xliffmsgplugin.XliffMsgPlugin;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class SoyFileSet {
    private static final Provider<SoyMsgBundleHandler> DEFAULT_SOY_MSG_BUNDLE_HANDLER_PROVIDER = Providers.of((Object)new SoyMsgBundleHandler(new XliffMsgPlugin()));
    private Provider<SoyMsgBundleHandler> msgBundleHandlerProvider = DEFAULT_SOY_MSG_BUNDLE_HANDLER_PROVIDER;
    private final BaseTofu.BaseTofuFactory baseTofuFactory;
    private final Provider<JsSrcMain> jsSrcMainProvider;
    private final Provider<JavaSrcMain> javaSrcMainProvider;
    private final PerformAutoescapeVisitor performAutoescapeVisitor;
    private final ContextualAutoescaper contextualAutoescaper;
    private final CheckFunctionCallsVisitor checkFunctionCallsVisitor;
    private final SimplifyVisitor simplifyVisitor;
    private final List<SoyFileSupplier> soyFileSuppliers;
    private final SoyGeneralOptions generalOptions;

    @Inject
    SoyFileSet(BaseTofu.BaseTofuFactory baseTofuFactory, Provider<JsSrcMain> jsSrcMainProvider, Provider<JavaSrcMain> javaSrcMainProvider, PerformAutoescapeVisitor performAutoescapeVisitor, ContextualAutoescaper contextualAutoescaper, SimplifyVisitor simplifyVisitor, CheckFunctionCallsVisitor checkFunctionCallsVisitor, @Assisted List<SoyFileSupplier> soyFileSuppliers, @Assisted SoyGeneralOptions generalOptions) {
        this.baseTofuFactory = baseTofuFactory;
        this.jsSrcMainProvider = jsSrcMainProvider;
        this.javaSrcMainProvider = javaSrcMainProvider;
        this.performAutoescapeVisitor = performAutoescapeVisitor;
        this.contextualAutoescaper = contextualAutoescaper;
        this.simplifyVisitor = simplifyVisitor;
        this.checkFunctionCallsVisitor = checkFunctionCallsVisitor;
        Preconditions.checkArgument((soyFileSuppliers.size() > 0 ? 1 : 0) != 0, (Object)"Must have non-zero number of input Soy files.");
        this.soyFileSuppliers = soyFileSuppliers;
        this.generalOptions = generalOptions.clone();
    }

    @Inject(optional=true)
    void setMsgBundleHandlerProvider(Provider<SoyMsgBundleHandler> msgBundleHandlerProvider) {
        this.msgBundleHandlerProvider = msgBundleHandlerProvider;
    }

    @VisibleForTesting
    List<SoyFileSupplier> getSoyFileSuppliersForTesting() {
        return this.soyFileSuppliers;
    }

    @VisibleForTesting
    SoyGeneralOptions getOptionsForTesting() {
        return this.generalOptions;
    }

    public ImmutableMap<String, String> generateParseInfo(String javaPackage, String javaClassNameSource) throws SoySyntaxException {
        SoyFileSetNode soyTree = new SoyFileSetParser(this.soyFileSuppliers).parse();
        return new GenerateParseInfoVisitor(javaPackage, javaClassNameSource).exec(soyTree);
    }

    public SoyMsgBundle extractMsgs() throws SoySyntaxException {
        SoyFileSetNode soyTree = new SoyFileSetParser(this.soyFileSuppliers).setDoEnforceSyntaxVersionV2(false).setDoCheckOverrides(false).parse();
        return new ExtractMsgsVisitor().exec(soyTree);
    }

    public SoyTofu compileToTofu() throws SoySyntaxException {
        return this.compileToTofu(new SoyTofuOptions());
    }

    public SoyTofu compileToTofu(SoyTofuOptions tofuOptions) throws SoySyntaxException {
        tofuOptions = tofuOptions.clone();
        SoyFileSetNode soyTree = new SoyFileSetParser(this.soyFileSuppliers).parse();
        this.runMiddleendPasses(soyTree, true);
        if (this.generalOptions.allowExternalCalls() == null) {
            // empty if block
        }
        new SubstituteGlobalsVisitor((Map<String, PrimitiveData>)this.generalOptions.getCompileTimeGlobals(), true).exec(soyTree);
        new ClearSoyDocStringsVisitor().exec(soyTree);
        return this.baseTofuFactory.create(soyTree, tofuOptions.useCaching());
    }

    @Deprecated
    public SoyTofu compileToJavaObj() throws SoySyntaxException {
        return this.compileToTofu(new SoyTofuOptions());
    }

    @Deprecated
    public SoyTofu compileToJavaObj(boolean useCaching) throws SoySyntaxException {
        SoyTofuOptions options = new SoyTofuOptions();
        options.setUseCaching(useCaching);
        return this.compileToTofu(options);
    }

    public SoyTemplateRuntimes compileToRuntimes(final String bundleName, SoyJavaSrcOptions options, final SoyMsgBundle msgBundle) {
        final SoyJavaSrcOptions copyOfOptions = options.clone();
        copyOfOptions.setCodeStyle(SoyJavaSrcOptions.CodeStyle.STRINGBUILDER);
        return new SoyTemplateRuntimes(){
            private List<SoyFileSupplier.Version> compiledVersions = null;
            private ImmutableMap<String, SoyTemplateRuntime> compiledTemplates;
            private final boolean isDynamic;
            {
                1 var5_5 = this;
                synchronized (var5_5) {
                    this.compile();
                    boolean isDynamic = false;
                    for (SoyFileSupplier.Version version : this.compiledVersions) {
                        if (version == SoyFileSupplier.Version.STABLE_VERSION) continue;
                        isDynamic = true;
                        break;
                    }
                    this.isDynamic = isDynamic;
                }
            }

            @Override
            public SoyTemplateRuntime newRenderer(String templateName) throws SoySyntaxException {
                if (this.isOutOfDate()) {
                    this.compile();
                }
                return (SoyTemplateRuntime)this.compiledTemplates.get((Object)templateName);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void compile() throws SoySyntaxException {
                Pair<SoyFileSetNode, List<SoyFileSupplier.Version>> soyTreeAndVersions = new SoyFileSetParser(SoyFileSet.this.soyFileSuppliers).parseWithVersions();
                SoyFileSetNode soyTree = (SoyFileSetNode)soyTreeAndVersions.first;
                SoyFileSet.this.runMiddleendPasses(soyTree, true);
                ImmutableMap<String, SoyTemplateRuntime> result = SoyToJavaDynamicCompiler.compile(bundleName, SoyFileSet.this.compileFileSetToJavaSrc(soyTree, copyOfOptions, msgBundle));
                1 var4_4 = this;
                synchronized (var4_4) {
                    this.compiledTemplates = result;
                    this.compiledVersions = (List)soyTreeAndVersions.second;
                }
            }

            private boolean isOutOfDate() {
                if (this.isDynamic) {
                    int numFiles = SoyFileSet.this.soyFileSuppliers.size();
                    for (int i = 0; i < numFiles; ++i) {
                        if (!((SoyFileSupplier)SoyFileSet.this.soyFileSuppliers.get(i)).hasChangedSince(this.compiledVersions.get(i))) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public String compileToJavaSrc(SoyJavaSrcOptions javaSrcOptions, SoyMsgBundle msgBundle) {
        SoyFileSetNode soyTree = new SoyFileSetParser(this.soyFileSuppliers).parse();
        this.runMiddleendPasses(soyTree, true);
        return this.compileFileSetToJavaSrc(soyTree, javaSrcOptions, msgBundle);
    }

    private String compileFileSetToJavaSrc(SoyFileSetNode soyTree, SoyJavaSrcOptions javaSrcOptions, SoyMsgBundle msgBundle) {
        new SubstituteGlobalsVisitor((Map<String, PrimitiveData>)this.generalOptions.getCompileTimeGlobals(), true).exec(soyTree);
        return ((JavaSrcMain)this.javaSrcMainProvider.get()).genJavaSrc(soyTree, javaSrcOptions, msgBundle);
    }

    public List<String> compileToJsSrc(SoyJsSrcOptions jsSrcOptions, @Nullable SoyMsgBundle msgBundle) throws SoySyntaxException {
        boolean doEnforceSyntaxVersionV2 = !jsSrcOptions.shouldAllowDeprecatedSyntax();
        SoyFileSetNode soyTree = new SoyFileSetParser(this.soyFileSuppliers).setDoEnforceSyntaxVersionV2(doEnforceSyntaxVersionV2).parse();
        this.runMiddleendPasses(soyTree, doEnforceSyntaxVersionV2);
        return ((JsSrcMain)this.jsSrcMainProvider.get()).genJsSrc(soyTree, jsSrcOptions, msgBundle);
    }

    void compileToJsSrcFiles(String outputPathFormat, String inputFilePathPrefix, SoyJsSrcOptions jsSrcOptions, List<String> locales, @Nullable String messageFilePathFormat) throws SoySyntaxException, IOException {
        boolean doEnforceSyntaxVersionV2 = !jsSrcOptions.shouldAllowDeprecatedSyntax();
        SoyFileSetNode soyTree = new SoyFileSetParser(this.soyFileSuppliers).setDoEnforceSyntaxVersionV2(doEnforceSyntaxVersionV2).parse();
        this.runMiddleendPasses(soyTree, doEnforceSyntaxVersionV2);
        if (locales.size() == 0) {
            ((JsSrcMain)this.jsSrcMainProvider.get()).genJsFiles(soyTree, jsSrcOptions, null, null, outputPathFormat, inputFilePathPrefix);
        } else {
            for (String locale : locales) {
                SoyFileSetNode soyTreeClone = soyTree.clone();
                String msgFilePath = JsSrcUtils.buildFilePath(messageFilePathFormat, locale, null, inputFilePathPrefix);
                SoyMsgBundle msgBundle = ((SoyMsgBundleHandler)this.msgBundleHandlerProvider.get()).createFromFile(new File(msgFilePath));
                if (msgBundle.getLocaleString() == null && !locale.startsWith("en")) {
                    throw new IOException("Error opening or reading message file " + msgFilePath);
                }
                ((JsSrcMain)this.jsSrcMainProvider.get()).genJsFiles(soyTreeClone, jsSrcOptions, locale, msgBundle, outputPathFormat, inputFilePathPrefix);
            }
        }
    }

    private void runMiddleendPasses(SoyFileSetNode soyTree, boolean doEnforceSyntaxVersionV2) throws SoySyntaxException {
        if (this.generalOptions.allowExternalCalls() == Boolean.FALSE) {
            new AssertNoExternalCallsVisitor().exec(soyTree);
        }
        new HandleCssCommandVisitor(this.generalOptions.getCssHandlingScheme()).exec(soyTree);
        if (this.generalOptions.getCompileTimeGlobals() != null) {
            new SubstituteGlobalsVisitor((Map<String, PrimitiveData>)this.generalOptions.getCompileTimeGlobals(), false).exec(soyTree);
        }
        this.checkFunctionCallsVisitor.setAllowExternallyDefinedFunctions(!doEnforceSyntaxVersionV2);
        this.checkFunctionCallsVisitor.exec(soyTree);
        this.doContextualEscaping(soyTree);
        this.performAutoescapeVisitor.exec(soyTree);
        new ChangeCallsToPassAllDataVisitor().exec(soyTree);
        this.simplifyVisitor.exec(soyTree);
    }

    private void doContextualEscaping(SoyFileSetNode soyTree) throws SoySyntaxException {
        new CheckEscapingSanityVisitor().exec(soyTree);
        List<TemplateNode> extraTemplates = this.contextualAutoescaper.rewrite(soyTree, this.generalOptions.allowExternalCalls() == Boolean.FALSE);
        if (!extraTemplates.isEmpty()) {
            HashMap containingFile = Maps.newHashMap();
            for (SoyFileNode fileNode : soyTree.getChildren()) {
                for (TemplateNode templateNode : fileNode.getChildren()) {
                    String name = templateNode instanceof TemplateDelegateNode ? ((TemplateDelegateNode)templateNode).getDelTemplateName() : templateNode.getTemplateName();
                    containingFile.put(DerivedTemplateUtils.getBaseName(name), fileNode);
                }
            }
            for (TemplateNode extraTemplate : extraTemplates) {
                String name = extraTemplate instanceof TemplateDelegateNode ? ((TemplateDelegateNode)extraTemplate).getDelTemplateName() : extraTemplate.getTemplateName();
                ((SoyFileNode)containingFile.get(DerivedTemplateUtils.getBaseName(name))).addChild(extraTemplate);
            }
        }
    }

    public static final class Builder {
        @Inject
        private static SoyFileSetFactory soyFileSetFactory = null;
        private final ImmutableList.Builder<SoyFileSupplier> listBuilder = ImmutableList.builder();
        private SoyGeneralOptions generalOptions;

        @Inject
        public Builder() {
            this(new SoyGeneralOptions());
        }

        public Builder(SoyGeneralOptions generalOptions) {
            this.generalOptions = generalOptions.clone();
            GuiceInitializer.initializeIfNecessary();
        }

        public SoyFileSet build() {
            return soyFileSetFactory.create((List<SoyFileSupplier>)this.listBuilder.build(), this.generalOptions);
        }

        public Builder addWithKind(InputSupplier<? extends Reader> contentSupplier, SoyFileKind soyFileKind, String filePath) {
            this.listBuilder.add((Object)SoyFileSupplier.Factory.create(contentSupplier, soyFileKind, filePath));
            return this;
        }

        public Builder add(InputSupplier<? extends Reader> contentSupplier, String filePath) {
            return this.addWithKind(contentSupplier, SoyFileKind.SRC, filePath);
        }

        public Builder addWithKind(File inputFile, SoyFileKind soyFileKind) {
            this.listBuilder.add((Object)SoyFileSupplier.Factory.create(inputFile, soyFileKind));
            return this;
        }

        public Builder add(File inputFile) {
            return this.addWithKind(inputFile, SoyFileKind.SRC);
        }

        public Builder addVolatileWithKind(File inputFile, SoyFileKind soyFileKind) {
            this.listBuilder.add((Object)new VolatileSoyFileSupplier(inputFile, soyFileKind));
            return this;
        }

        public Builder addVolatile(File inputFile) {
            return this.addVolatileWithKind(inputFile, SoyFileKind.SRC);
        }

        public Builder addWithKind(URL inputFileUrl, SoyFileKind soyFileKind, String filePath) {
            this.listBuilder.add((Object)SoyFileSupplier.Factory.create(inputFileUrl, soyFileKind, filePath));
            return this;
        }

        public Builder add(URL inputFileUrl, String filePath) {
            return this.addWithKind(inputFileUrl, SoyFileKind.SRC, filePath);
        }

        public Builder addWithKind(URL inputFileUrl, SoyFileKind soyFileKind) {
            this.listBuilder.add((Object)SoyFileSupplier.Factory.create(inputFileUrl, soyFileKind));
            return this;
        }

        public Builder add(URL inputFileUrl) {
            return this.addWithKind(inputFileUrl, SoyFileKind.SRC);
        }

        public Builder addWithKind(CharSequence content, SoyFileKind soyFileKind, String filePath) {
            this.listBuilder.add((Object)SoyFileSupplier.Factory.create(content, soyFileKind, filePath));
            return this;
        }

        public Builder add(CharSequence content, String filePath) {
            return this.addWithKind(content, SoyFileKind.SRC, filePath);
        }

        public Builder setAllowExternalCalls(boolean allowExternalCalls) {
            this.generalOptions.setAllowExternalCalls(allowExternalCalls);
            return this;
        }

        public Builder setCssHandlingScheme(SoyGeneralOptions.CssHandlingScheme cssHandlingScheme) {
            this.generalOptions.setCssHandlingScheme(cssHandlingScheme);
            return this;
        }

        public Builder setCompileTimeGlobals(Map<String, ?> compileTimeGlobalsMap) {
            this.generalOptions.setCompileTimeGlobals(compileTimeGlobalsMap);
            return this;
        }

        public Builder setCompileTimeGlobals(File compileTimeGlobalsFile) throws IOException {
            this.generalOptions.setCompileTimeGlobals(compileTimeGlobalsFile);
            return this;
        }

        public Builder setCompileTimeGlobals(URL compileTimeGlobalsResource) throws IOException {
            this.generalOptions.setCompileTimeGlobals(compileTimeGlobalsResource);
            return this;
        }
    }

    static interface SoyFileSetFactory {
        public SoyFileSet create(List<SoyFileSupplier> var1, SoyGeneralOptions var2);
    }
}

