/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.tofu.internal;

import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.sharedpasses.render.EvalVisitor;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.RenderVisitor;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.tofu.restricted.SoyTofuPrintDirective;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class TofuRenderVisitor
extends RenderVisitor {
    private final Map<String, SoyTofuPrintDirective> soyTofuDirectivesMap;

    protected TofuRenderVisitor(Map<String, SoyTofuPrintDirective> soyTofuDirectivesMap, EvalVisitor.EvalVisitorFactory evalVisitorFactory, RenderVisitor.RenderVisitorFactory renderVisitorFactory, Appendable outputSb, @Nullable TemplateRegistry templateRegistry, @Nullable SoyMapData data, @Nullable SoyMapData ijData, @Nullable Deque<Map<String, SoyData>> env, @Nullable Set<String> activeDelPackageNames, @Nullable SoyMsgBundle msgBundle, @Nullable SoyCssRenamingMap cssRenamingMap) {
        super(null, evalVisitorFactory, renderVisitorFactory, outputSb, templateRegistry, data, ijData, env, activeDelPackageNames, msgBundle, cssRenamingMap);
        this.soyTofuDirectivesMap = soyTofuDirectivesMap;
    }

    @Override
    protected String applyDirective(String directiveName, SoyData value, List<SoyData> args, PrintNode printNode) {
        SoyTofuPrintDirective directive = this.soyTofuDirectivesMap.get(directiveName);
        if (directive == null) {
            throw new RenderException("Failed to find Soy print directive with name '" + directiveName + "'" + " (tag " + printNode.toSourceString() + ")");
        }
        if (!directive.getValidArgsSizes().contains(args.size())) {
            throw new RenderException("Print directive '" + directiveName + "' used with the wrong number of" + " arguments (tag " + printNode.toSourceString() + ").");
        }
        return directive.applyForTofu(value, args);
    }
}

