/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.tofu.internal;

import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.sharedpasses.render.EvalVisitor;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.tofu.restricted.SoyTofuFunction;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class TofuEvalVisitor
extends EvalVisitor {
    private final Map<String, SoyTofuFunction> soyTofuFunctionsMap;

    protected TofuEvalVisitor(@Nullable Map<String, SoyTofuFunction> soyTofuFunctionsMap, @Nullable SoyMapData data, @Nullable SoyMapData ijData, Deque<Map<String, SoyData>> env) {
        super(null, data, ijData, env);
        this.soyTofuFunctionsMap = soyTofuFunctionsMap;
    }

    @Override
    protected SoyData computeFunction(String fnName, List<SoyData> args, FunctionNode fnNode) {
        SoyTofuFunction fn = this.soyTofuFunctionsMap.get(fnName);
        if (fn == null) {
            throw new RenderException("Failed to find Soy function with name '" + fnName + "'" + " (function call \"" + fnNode.toSourceString() + "\").");
        }
        try {
            return fn.computeForTofu(args);
        }
        catch (Exception e) {
            throw new RenderException("Error while computing function \"" + fnNode.toSourceString() + "\": " + e.getMessage());
        }
    }
}

