/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

public class TemplateRegistry {
    private final Map<String, TemplateBasicNode> basicTemplatesMap;
    private final Map<String, List<DelegateTemplateDivision>> delTemplatesMap;

    public TemplateRegistry(SoyFileSetNode soyTree) {
        HashMap tempBasicTemplatesMap = Maps.newHashMap();
        HashMap tempDelTemplatesMap = Maps.newHashMap();
        for (SoyFileNode soyFile : soyTree.getChildren()) {
            for (TemplateNode template : soyFile.getChildren()) {
                Map tempDivision;
                if (template instanceof TemplateBasicNode) {
                    tempBasicTemplatesMap.put(template.getTemplateName(), (TemplateBasicNode)template);
                    continue;
                }
                TemplateDelegateNode delTemplate = (TemplateDelegateNode)template;
                String delTemplateName = delTemplate.getDelTemplateName();
                int delPriority = delTemplate.getDelPriority();
                String delPackageName = delTemplate.getDelPackageName();
                Map tempDivisions = (Map)tempDelTemplatesMap.get(delTemplateName);
                if (tempDivisions == null) {
                    tempDivisions = Maps.newHashMap();
                    tempDelTemplatesMap.put(delTemplateName, tempDivisions);
                }
                if ((tempDivision = (Map)tempDivisions.get(delPriority)) == null) {
                    tempDivision = Maps.newHashMap();
                    tempDivisions.put(delPriority, tempDivision);
                }
                if (tempDivision.containsKey(delPackageName)) {
                    TemplateDelegateNode prevTemplate = (TemplateDelegateNode)tempDivision.get(delPackageName);
                    String prevTemplateFilePath = prevTemplate.getNearestAncestor(SoyFileNode.class).getFilePath();
                    String currTemplateFilePath = delTemplate.getNearestAncestor(SoyFileNode.class).getFilePath();
                    if (currTemplateFilePath.equals(prevTemplateFilePath)) {
                        throw new SoySyntaxException(String.format("Found two definitions for delegate template name '%s' in the same delegatepackage, both in the file %s.", delTemplateName, currTemplateFilePath));
                    }
                    throw new SoySyntaxException(String.format("Found two definitions for delegate template name '%s' in the same delegatepackage, in two different files %s and %s.", delTemplateName, prevTemplateFilePath, currTemplateFilePath));
                }
                tempDivision.put(delPackageName, delTemplate);
            }
        }
        this.basicTemplatesMap = Collections.unmodifiableMap(tempBasicTemplatesMap);
        ImmutableMap.Builder delTemplatesMapBuilder = ImmutableMap.builder();
        for (String delTemplateName : tempDelTemplatesMap.keySet()) {
            Map tempDivisions = (Map)tempDelTemplatesMap.get(delTemplateName);
            ImmutableList.Builder divisionsBuilder = ImmutableList.builder();
            for (int priority = 1; priority >= 0; --priority) {
                if (!tempDivisions.containsKey(priority)) continue;
                Map tempDivision = (Map)tempDivisions.get(priority);
                DelegateTemplateDivision division = new DelegateTemplateDivision(priority, tempDivision);
                divisionsBuilder.add((Object)division);
            }
            delTemplatesMapBuilder.put((Object)delTemplateName, (Object)divisionsBuilder.build());
        }
        this.delTemplatesMap = delTemplatesMapBuilder.build();
    }

    public Map<String, TemplateBasicNode> getBasicTemplatesMap() {
        return this.basicTemplatesMap;
    }

    public TemplateBasicNode getBasicTemplate(String templateName) {
        return this.basicTemplatesMap.get(templateName);
    }

    public Map<String, List<DelegateTemplateDivision>> getDelegateTemplatesMap() {
        return this.delTemplatesMap;
    }

    public List<DelegateTemplateDivision> getSortedDelegateTemplateDivisions(String delTemplateName) {
        return this.delTemplatesMap.get(delTemplateName);
    }

    public TemplateDelegateNode selectDelegateTemplate(String delTemplateName, Set<String> activeDelPackageNames) throws DelegateTemplateConflictException {
        List<DelegateTemplateDivision> divisions = this.delTemplatesMap.get(delTemplateName);
        if (divisions == null) {
            return null;
        }
        for (DelegateTemplateDivision division : divisions) {
            TemplateDelegateNode delTemplate = null;
            for (String delPackageName : division.delPackageNameToDelTemplateMap.keySet()) {
                if (delPackageName != null && !activeDelPackageNames.contains(delPackageName)) continue;
                if (delTemplate != null) {
                    throw new DelegateTemplateConflictException(String.format("For delegate template name '%s', found two active implementations with equal priority in delegate packages '%s' and '%s'.", delTemplateName, delTemplate.getDelPackageName(), delPackageName));
                }
                delTemplate = division.delPackageNameToDelTemplateMap.get(delPackageName);
            }
            if (delTemplate == null) continue;
            return delTemplate;
        }
        return null;
    }

    public static class DelegateTemplateConflictException
    extends Exception {
        public DelegateTemplateConflictException(String errorMsg) {
            super(errorMsg);
        }
    }

    @Immutable
    public static class DelegateTemplateDivision {
        public final int delPriority;
        public final Map<String, TemplateDelegateNode> delPackageNameToDelTemplateMap;

        public DelegateTemplateDivision(int delPriority, Map<String, TemplateDelegateNode> delPackageNameToDelTemplateMap) {
            this.delPriority = delPriority;
            this.delPackageNameToDelTemplateMap = Collections.unmodifiableMap(Maps.newHashMap(delPackageNameToDelTemplateMap));
        }
    }
}

