/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class TemplateDelegateNode
extends TemplateNode {
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("([.\\w]+) ( \\s .* | $ )", 36);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("deltemplate", new CommandTextAttributesParser.Attribute("autoescape", AutoescapeMode.getAttributeValuesAndNull(), null));
    private final String delTemplateName;
    private final int delPriority;

    public TemplateDelegateNode(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String commandText, @Nullable String soyDoc) throws SoySyntaxException {
        this(id, soyFileHeaderInfo, TemplateDelegateNode.parseCommandTextHelper(id, soyFileHeaderInfo, commandText), soyDoc);
    }

    public TemplateDelegateNode(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String delTemplateName, int delPriority, AutoescapeMode autoescapeMode, @Nullable String soyDoc) {
        this(id, soyFileHeaderInfo, TemplateDelegateNode.buildCommandTextInfoHelper(id, soyFileHeaderInfo, null, delTemplateName, delPriority, autoescapeMode), soyDoc);
    }

    private static final CommandTextInfo parseCommandTextHelper(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String commandText) {
        Matcher matcher = COMMAND_TEXT_PATTERN.matcher(commandText);
        if (!matcher.matches()) {
            throw new SoySyntaxException("Invalid 'deltemplate' command text \"" + commandText + "\".");
        }
        String delTemplateName = matcher.group(1);
        if (!BaseUtils.isDottedIdentifier(delTemplateName)) {
            throw new SoySyntaxException("Invalid delegate template name \"" + delTemplateName + "\".");
        }
        Map<String, String> attributes = ATTRIBUTES_PARSER.parse(matcher.group(2).trim());
        int delPriority = soyFileHeaderInfo.defaultDelPriority;
        if (delPriority < 0 || delPriority > 1) {
            throw new SoySyntaxException(String.format("Invalid delegate template priority %s (valid range is 0 to %s).", delPriority, 1));
        }
        String autoescapeModeStr = attributes.get("autoescape");
        AutoescapeMode autoescapeMode = autoescapeModeStr != null ? AutoescapeMode.forAttributeValue(autoescapeModeStr) : soyFileHeaderInfo.defaultAutoescapeMode;
        return TemplateDelegateNode.buildCommandTextInfoHelper(id, soyFileHeaderInfo, commandText, delTemplateName, delPriority, autoescapeMode);
    }

    private static CommandTextInfo buildCommandTextInfoHelper(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, @Nullable String commandText, String delTemplateName, int delPriority, AutoescapeMode autoescapeMode) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(delTemplateName));
        Preconditions.checkArgument((0 <= delPriority && delPriority <= 1 ? 1 : 0) != 0);
        if (commandText == null) {
            commandText = delTemplateName + " autoescape=\"" + autoescapeMode.getAttributeValue() + "\"";
        }
        String generatedPartialTemplateName = ".__soy_deltemplate" + id;
        String generatedTemplateName = soyFileHeaderInfo.namespace + generatedPartialTemplateName;
        return new CommandTextInfo(commandText, delTemplateName, delPriority, generatedTemplateName, generatedPartialTemplateName, autoescapeMode);
    }

    private TemplateDelegateNode(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, CommandTextInfo commandTextInfo, @Nullable String soyDoc) {
        super(id, soyFileHeaderInfo, "deltemplate", commandTextInfo, soyDoc);
        this.delTemplateName = commandTextInfo.delTemplateName;
        this.delPriority = commandTextInfo.delPriority;
    }

    protected TemplateDelegateNode(TemplateDelegateNode orig) {
        super(orig);
        this.delTemplateName = orig.delTemplateName;
        this.delPriority = orig.delPriority;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.TEMPLATE_DELEGATE_NODE;
    }

    @Override
    public String getTemplateNameForUserMsgs() {
        return this.delTemplateName;
    }

    public String getDelTemplateName() {
        return this.delTemplateName;
    }

    public int getDelPriority() {
        return this.delPriority;
    }

    @Override
    public TemplateDelegateNode clone() {
        return new TemplateDelegateNode(this);
    }

    @Immutable
    private static class CommandTextInfo
    extends TemplateNode.CommandTextInfo {
        public final String delTemplateName;
        public final int delPriority;

        public CommandTextInfo(String commandText, String delTemplateName, int delPriority, String templateName, @Nullable String partialTemplateName, AutoescapeMode autoescapeMode) {
            super(commandText, templateName, partialTemplateName, false, autoescapeMode, SoyNode.SyntaxVersion.V2);
            this.delTemplateName = delTemplateName;
            this.delPriority = delPriority;
        }
    }
}

