/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class TemplateBasicNode
extends TemplateNode {
    private static final Pattern NONATTRIBUTE_TEMPLATE_NAME = Pattern.compile("^ (?! name=\") [.\\w]+ (?= \\s | $)", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("template", new CommandTextAttributesParser.Attribute("name", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, "__NDVBR__"), new CommandTextAttributesParser.Attribute("private", CommandTextAttributesParser.Attribute.BOOLEAN_VALUES, "false"), new CommandTextAttributesParser.Attribute("override", CommandTextAttributesParser.Attribute.BOOLEAN_VALUES_AND_NULL, null), new CommandTextAttributesParser.Attribute("autoescape", AutoescapeMode.getAttributeValuesAndNull(), null));
    private final boolean isOverride;

    public TemplateBasicNode(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String commandText, @Nullable String soyDoc) throws SoySyntaxException {
        this(id, soyFileHeaderInfo, TemplateBasicNode.parseCommandTextHelper(soyFileHeaderInfo, commandText), soyDoc);
    }

    private static final CommandTextInfo parseCommandTextHelper(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String commandText) {
        boolean isOverride;
        String templateName;
        String partialTemplateName;
        Map<String, String> attributes;
        String nameAttr;
        SoyNode.SyntaxVersion syntaxVersion = SoyNode.SyntaxVersion.V2;
        String commandTextForParsing = commandText;
        Matcher ntnMatcher = NONATTRIBUTE_TEMPLATE_NAME.matcher(commandTextForParsing);
        if (ntnMatcher.find()) {
            commandTextForParsing = ntnMatcher.replaceFirst("name=\"" + ntnMatcher.group() + "\"");
        }
        if (BaseUtils.isIdentifierWithLeadingDot(nameAttr = (attributes = ATTRIBUTES_PARSER.parse(commandTextForParsing)).get("name"))) {
            partialTemplateName = nameAttr;
            templateName = soyFileHeaderInfo.namespace + partialTemplateName;
        } else if (BaseUtils.isDottedIdentifier(nameAttr)) {
            syntaxVersion = SoyNode.SyntaxVersion.V1;
            templateName = nameAttr;
            partialTemplateName = null;
        } else {
            throw new SoySyntaxException("Invalid template name \"" + nameAttr + "\".");
        }
        boolean isPrivate = attributes.get("private").equals("true");
        String overrideAttr = attributes.get("override");
        if (overrideAttr == null) {
            isOverride = false;
        } else {
            syntaxVersion = SoyNode.SyntaxVersion.V1;
            isOverride = overrideAttr.equals("true");
        }
        String autoescapeModeStr = attributes.get("autoescape");
        AutoescapeMode autoescapeMode = autoescapeModeStr != null ? AutoescapeMode.forAttributeValue(autoescapeModeStr) : soyFileHeaderInfo.defaultAutoescapeMode;
        return new CommandTextInfo(commandText, templateName, partialTemplateName, isOverride, isPrivate, autoescapeMode, syntaxVersion);
    }

    public TemplateBasicNode(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String templateName, @Nullable String partialTemplateName, boolean useAttrStyleForName, boolean isOverride, boolean isPrivate, AutoescapeMode autoescapeMode, @Nullable String soyDoc, SoyNode.SyntaxVersion syntaxVersion) {
        this(id, soyFileHeaderInfo, TemplateBasicNode.buildCommandTextInfoHelper(templateName, partialTemplateName, useAttrStyleForName, isOverride, isPrivate, autoescapeMode, syntaxVersion), soyDoc);
    }

    private static final CommandTextInfo buildCommandTextInfoHelper(String templateName, @Nullable String partialTemplateName, boolean useAttrStyleForName, boolean isOverride, boolean isPrivate, AutoescapeMode autoescapeMode, SoyNode.SyntaxVersion syntaxVersion) {
        String templateNameInCommandText;
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(templateName));
        Preconditions.checkArgument((partialTemplateName == null || BaseUtils.isIdentifierWithLeadingDot(partialTemplateName) ? 1 : 0) != 0);
        StringBuilder commandText = new StringBuilder();
        String string = templateNameInCommandText = partialTemplateName != null ? partialTemplateName : templateName;
        if (useAttrStyleForName) {
            commandText.append("name=\"").append(templateNameInCommandText).append('\"');
        } else {
            commandText.append(templateNameInCommandText);
        }
        commandText.append(" autoescape=\"").append(autoescapeMode.getAttributeValue()).append('\"');
        if (isOverride) {
            commandText.append(" override=\"true\"");
        }
        if (isPrivate) {
            commandText.append(" private=\"true\"");
        }
        return new CommandTextInfo(commandText.toString(), templateName, partialTemplateName, isOverride, isPrivate, autoescapeMode, syntaxVersion);
    }

    private TemplateBasicNode(int id, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, CommandTextInfo commandTextInfo, @Nullable String soyDoc) {
        super(id, soyFileHeaderInfo, "template", commandTextInfo, soyDoc);
        this.isOverride = commandTextInfo.isOverride;
    }

    protected TemplateBasicNode(TemplateBasicNode orig) {
        super(orig);
        this.isOverride = orig.isOverride;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.TEMPLATE_BASIC_NODE;
    }

    @Override
    public String getTemplateNameForUserMsgs() {
        return this.getTemplateName();
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    @Override
    public TemplateBasicNode clone() {
        return new TemplateBasicNode(this);
    }

    @Immutable
    private static class CommandTextInfo
    extends TemplateNode.CommandTextInfo {
        public final boolean isOverride;

        public CommandTextInfo(String commandText, String templateName, @Nullable String partialTemplateName, boolean isOverride, boolean isPrivate, AutoescapeMode autoescapeMode, SoyNode.SyntaxVersion syntaxVersion) {
            super(commandText, templateName, partialTemplateName, isPrivate, autoescapeMode, syntaxVersion);
            this.isOverride = isOverride;
        }
    }
}

