/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import javax.annotation.Nullable;

public class SoytreeUtils {
    public static SoySyntaxException createSoySyntaxExceptionWithMetaInfo(@Nullable String message, @Nullable Throwable cause, SoyNode soyNode) {
        SoySyntaxException sse;
        if (message != null && cause != null) {
            sse = new SoySyntaxException(message, cause);
        } else if (message != null) {
            sse = new SoySyntaxException(message);
        } else if (cause != null) {
            sse = new SoySyntaxException(cause);
        } else {
            throw new AssertionError();
        }
        SoytreeUtils.associateMetaInfoWithException(soyNode, sse);
        return sse;
    }

    private static void associateMetaInfoWithException(SoyNode soyNode, SoySyntaxException sse) {
        TemplateNode template = soyNode.getNearestAncestor(TemplateNode.class);
        if (sse.getSourceLocation() == SourceLocation.UNKNOWN) {
            sse.setSourceLocation(soyNode.getLocation());
        }
        if (sse.getTemplateName() == null && template != null) {
            sse.setTemplateName(template.getTemplateNameForUserMsgs());
        }
    }

    public static <R> void execOnAllV2Exprs(SoyNode node, AbstractExprNodeVisitor<R> exprNodeVisitor) {
        SoytreeUtils.execOnAllV2ExprsShortcircuitably(node, exprNodeVisitor, null);
    }

    public static <R> void execOnAllV2ExprsShortcircuitably(SoyNode node, AbstractExprNodeVisitor<R> exprNodeVisitor, Shortcircuiter<R> shortcircuiter) {
        new VisitAllV2ExprsVisitor<R>(exprNodeVisitor, shortcircuiter).exec(node);
    }

    public static <T extends SoyNode> T cloneWithNewIds(T origNode) {
        SoyNode clone = origNode.clone();
        IdGenerator nodeIdGen = origNode.getNearestAncestor(SoyFileSetNode.class).getNodeIdGenerator();
        new GenNewIdsVisitor(nodeIdGen).exec(clone);
        return (T)clone;
    }

    private static class GenNewIdsVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private IdGenerator nodeIdGen;

        public GenNewIdsVisitor(IdGenerator nodeIdGen) {
            this.nodeIdGen = nodeIdGen;
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            node.setId(this.nodeIdGen.genId());
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }

    private static class VisitAllV2ExprsVisitor<R>
    extends AbstractSoyNodeVisitor<R> {
        private final AbstractExprNodeVisitor<R> exprNodeVisitor;
        private final Shortcircuiter<R> shortcircuiter;

        public VisitAllV2ExprsVisitor(AbstractExprNodeVisitor<R> exprNodeVisitor, @Nullable Shortcircuiter<R> shortcircuiter) {
            this.exprNodeVisitor = exprNodeVisitor;
            this.shortcircuiter = shortcircuiter;
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                for (SoyNode child : ((SoyNode.ParentSoyNode)node).getChildren()) {
                    this.visit(child);
                    if (this.shortcircuiter == null || !this.shortcircuiter.shouldShortcircuit(this.exprNodeVisitor)) continue;
                    return;
                }
            }
            if (node instanceof SoyNode.ExprHolderNode) {
                SoyNode.ExprHolderNode nodeAsExprHolder = (SoyNode.ExprHolderNode)node;
                for (ExprUnion exprUnion : nodeAsExprHolder.getAllExprUnions()) {
                    if (exprUnion.getExpr() == null) continue;
                    try {
                        this.exprNodeVisitor.exec(exprUnion.getExpr());
                    }
                    catch (SoySyntaxException sse) {
                        SoytreeUtils.associateMetaInfoWithException(nodeAsExprHolder, sse);
                        throw sse;
                    }
                }
            }
        }
    }

    public static interface Shortcircuiter<R> {
        public boolean shouldShortcircuit(AbstractExprNodeVisitor<R> var1);
    }
}

