/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.CharMatcher;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class SoyFileNode
extends AbstractParentSoyNode<TemplateNode>
implements SoyNode.SplitLevelTopNode<TemplateNode> {
    private final String delPackageName;
    private final String namespace;
    private final AutoescapeMode defaultAutoescapeMode;
    private String filePath;
    private String fileName;
    private static final Pattern CMD_TEXT_PATTERN = Pattern.compile("\\s* ([a-zA-Z_][a-zA-Z_0-9]*(?:[.][a-zA-Z_][a-zA-Z_0-9]*)*) (\\s .*)?", 4);
    private static final AutoescapeMode DEFAULT_FILE_WIDE_DEFAULT_AUTOESCAPE_MODE = AutoescapeMode.TRUE;
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("namespace", new CommandTextAttributesParser.Attribute("autoescape", AutoescapeMode.getAttributeValues(), DEFAULT_FILE_WIDE_DEFAULT_AUTOESCAPE_MODE.getAttributeValue()));

    public SoyFileNode(int id, @Nullable String delpackageCmdText, @Nullable String namespaceCmdText) throws SoySyntaxException {
        super(id);
        if (delpackageCmdText != null) {
            this.delPackageName = delpackageCmdText.trim();
            if (!BaseUtils.isDottedIdentifier(this.delPackageName)) {
                throw new SoySyntaxException("Invalid delegate package name \"" + this.delPackageName + "\".");
            }
        } else {
            this.delPackageName = null;
        }
        String namespace = null;
        AutoescapeMode defaultAutoescapeMode = DEFAULT_FILE_WIDE_DEFAULT_AUTOESCAPE_MODE;
        if (namespaceCmdText != null) {
            Matcher matcher = CMD_TEXT_PATTERN.matcher(namespaceCmdText);
            if (matcher.matches()) {
                Map<String, String> attributes;
                namespace = matcher.group(1);
                String attributeText = matcher.group(2);
                if (attributeText != null && (attributes = ATTRIBUTES_PARSER.parse(attributeText = attributeText.trim())).containsKey("autoescape")) {
                    defaultAutoescapeMode = AutoescapeMode.forAttributeValue(attributes.get("autoescape"));
                }
            } else {
                throw new SoySyntaxException("Invalid namespace command text \"" + namespaceCmdText + "\".");
            }
        }
        this.namespace = namespace;
        this.defaultAutoescapeMode = defaultAutoescapeMode;
        if (namespace == null) {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
        } else if (!BaseUtils.isDottedIdentifier(namespace)) {
            throw new SoySyntaxException("Invalid namespace name \"" + namespace + "\".");
        }
    }

    protected SoyFileNode(SoyFileNode orig) {
        super(orig);
        this.delPackageName = orig.delPackageName;
        this.namespace = orig.namespace;
        this.defaultAutoescapeMode = orig.defaultAutoescapeMode;
        this.filePath = orig.filePath;
        this.fileName = orig.fileName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.SOY_FILE_NODE;
    }

    public String getDelPackageName() {
        return this.delPackageName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public AutoescapeMode getDefaultAutoescapeMode() {
        return this.defaultAutoescapeMode;
    }

    public void setFilePath(String filePath) {
        int lastBangIndex = filePath.lastIndexOf(33);
        if (lastBangIndex != -1) {
            filePath = filePath.substring(lastBangIndex + 1);
        }
        this.filePath = filePath;
        int lastSlashIndex = CharMatcher.anyOf((CharSequence)"/\\").lastIndexIn((CharSequence)filePath);
        this.fileName = lastSlashIndex != -1 && lastSlashIndex != filePath.length() - 1 ? filePath.substring(lastSlashIndex + 1) : filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        if (this.namespace != null) {
            sb.append("{namespace ").append(this.namespace).append("}\n");
        }
        for (TemplateNode child : this.getChildren()) {
            sb.append("\n");
            sb.append(child.toSourceString());
        }
        return sb.toString();
    }

    @Override
    public SoyFileNode clone() {
        return new SoyFileNode(this);
    }
}

