/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import javax.annotation.Nullable;

public class PrintNode
extends AbstractParentCommandNode<PrintDirectiveNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<PrintDirectiveNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode,
SoyNode.MsgPlaceholderInitialContentNode {
    public static final String FALLBACK_BASE_PLACEHOLDER_NAME = "XXX";
    private final boolean isImplicit;
    private final ExprUnion exprUnion;
    @Nullable
    private final String userSuppliedPlaceholderName;

    public PrintNode(int id, boolean isImplicit, String exprText, @Nullable String userSuppliedPlaceholderName) throws SoySyntaxException {
        super(id, "print", "");
        ExprRootNode<?> expr;
        this.isImplicit = isImplicit;
        try {
            expr = new ExpressionParser(exprText).parseExpression();
        }
        catch (TokenMgrError tme) {
            expr = null;
        }
        catch (ParseException pe) {
            expr = null;
        }
        if (expr != null) {
            this.exprUnion = new ExprUnion(expr);
        } else {
            this.maybeSetSyntaxVersion(SoyNode.SyntaxVersion.V1);
            this.exprUnion = new ExprUnion(exprText);
        }
        this.userSuppliedPlaceholderName = userSuppliedPlaceholderName;
    }

    public PrintNode(int id, boolean isImplicit, ExprUnion exprUnion, @Nullable String userSuppliedPlaceholderName) {
        super(id, "print", "");
        this.isImplicit = isImplicit;
        this.exprUnion = exprUnion;
        this.userSuppliedPlaceholderName = userSuppliedPlaceholderName;
    }

    protected PrintNode(PrintNode orig) {
        super(orig);
        this.isImplicit = orig.isImplicit;
        this.exprUnion = orig.exprUnion != null ? orig.exprUnion.clone() : null;
        this.userSuppliedPlaceholderName = orig.userSuppliedPlaceholderName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.PRINT_NODE;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public String getExprText() {
        return this.exprUnion.getExprText();
    }

    public ExprUnion getExprUnion() {
        return this.exprUnion;
    }

    @Override
    public String getUserSuppliedPlaceholderName() {
        return this.userSuppliedPlaceholderName;
    }

    @Override
    public String genBasePlaceholderName() {
        if (this.userSuppliedPlaceholderName != null) {
            return BaseUtils.convertToUpperUnderscore(this.userSuppliedPlaceholderName);
        }
        ExprRootNode<?> exprRoot = this.exprUnion.getExpr();
        if (exprRoot == null) {
            return FALLBACK_BASE_PLACEHOLDER_NAME;
        }
        Node exprNode = exprRoot.getChild(0);
        if (exprNode instanceof DataRefNode) {
            DataRefNode dataRefNode = (DataRefNode)exprNode;
            ExprNode lastPart = dataRefNode.getChild(dataRefNode.numChildren() - 1);
            if (lastPart instanceof DataRefKeyNode) {
                return BaseUtils.convertToUpperUnderscore(((DataRefKeyNode)lastPart).getKey());
            }
        } else if (exprNode instanceof GlobalNode) {
            GlobalNode globalNode = (GlobalNode)exprNode;
            int lastDotIndex = globalNode.getName().lastIndexOf(46);
            String lastPart = globalNode.getName().substring(lastDotIndex + 1);
            return BaseUtils.convertToUpperUnderscore(lastPart);
        }
        return FALLBACK_BASE_PLACEHOLDER_NAME;
    }

    @Override
    public Object genSamenessKey() {
        return this.getCommandText();
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)this.exprUnion);
    }

    @Override
    public String getCommandText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.exprUnion.getExprText());
        for (PrintDirectiveNode child : this.getChildren()) {
            sb.append(' ').append(child.toSourceString());
        }
        if (this.userSuppliedPlaceholderName != null) {
            sb.append(" phname=\"").append(this.userSuppliedPlaceholderName).append('\"');
        }
        return sb.toString();
    }

    @Override
    public String getTagString() {
        return this.buildTagStringHelper(false, this.isImplicit);
    }

    @Override
    public String toSourceString() {
        return this.getTagString();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public PrintNode clone() {
        return new PrintNode(this);
    }
}

