/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public class MsgSelectNode
extends AbstractParentCommandNode<CaseOrDefaultNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<CaseOrDefaultNode>,
SoyNode.ExprHolderNode {
    private final ExprRootNode<?> selectExpr;

    public MsgSelectNode(int id, String commandText) throws SoySyntaxException {
        super(id, "select", commandText);
        try {
            this.selectExpr = new ExpressionParser(commandText).parseExpression();
        }
        catch (TokenMgrError tme) {
            throw this.createExceptionForInvalidCommandText(tme);
        }
        catch (ParseException pe) {
            throw this.createExceptionForInvalidCommandText(pe);
        }
    }

    protected MsgSelectNode(MsgSelectNode orig) {
        super(orig);
        this.selectExpr = orig.selectExpr.clone();
    }

    private SoySyntaxException createExceptionForInvalidCommandText(Throwable cause) {
        return new SoySyntaxException("Invalid data reference in 'select' command text \"" + this.getCommandText() + "\".", cause);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_SELECT_NODE;
    }

    public String getExprText() {
        return this.selectExpr.toSourceString();
    }

    public ExprRootNode<?> getExpr() {
        return this.selectExpr;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)new ExprUnion(this.selectExpr));
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public MsgSelectNode clone() {
        return new MsgSelectNode(this);
    }
}

