/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.soytree.AbstractBlockNode;
import com.google.template.soy.soytree.SoyNode;
import javax.annotation.Nullable;

public class MsgPlaceholderNode
extends AbstractBlockNode
implements SoyNode.StandaloneNode {
    private final String basePlaceholderName;
    private final SoyNode.Kind initialContentKind;
    @Nullable
    private final Object samenessKey;

    public MsgPlaceholderNode(int id, SoyNode.MsgPlaceholderInitialContentNode initialContent) {
        super(id);
        this.basePlaceholderName = initialContent.genBasePlaceholderName();
        this.initialContentKind = initialContent.getKind();
        this.samenessKey = initialContent.genSamenessKey();
        this.addChild(initialContent);
    }

    protected MsgPlaceholderNode(MsgPlaceholderNode orig) {
        super(orig);
        this.basePlaceholderName = orig.basePlaceholderName;
        this.initialContentKind = orig.initialContentKind;
        this.samenessKey = orig.samenessKey;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_PLACEHOLDER_NODE;
    }

    public String genBasePlaceholderName() {
        return this.basePlaceholderName;
    }

    public boolean isSamePlaceholderAs(MsgPlaceholderNode other) {
        return this.initialContentKind == other.initialContentKind && (this.samenessKey == null ? other.samenessKey == null : this.samenessKey.equals(other.samenessKey));
    }

    @Override
    public String toSourceString() {
        return ((SoyNode.StandaloneNode)this.getChild(0)).toSourceString();
    }

    @Override
    public SoyNode.MsgBlockNode getParent() {
        return (SoyNode.MsgBlockNode)super.getParent();
    }

    @Override
    public MsgPlaceholderNode clone() {
        return new MsgPlaceholderNode(this);
    }
}

