/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarNode;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class LetNode
extends AbstractCommandNode
implements SoyNode.StandaloneNode,
SoyNode.StatementNode,
SoyNode.LocalVarInlineNode {
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("( [$] \\w+ ) (?: \\s* : \\s* (\\S .*) )?", 36);
    private final boolean isVarNameUnique;

    protected LetNode(int id, boolean isVarNameUnique, String commandText) {
        super(id, "let", commandText);
        this.isVarNameUnique = isVarNameUnique;
    }

    protected LetNode(LetNode orig) {
        super(orig);
        this.isVarNameUnique = orig.isVarNameUnique;
    }

    protected Pair<String, ExprRootNode<?>> parseCommandTextHelper(String commandText) throws SoySyntaxException {
        ExprRootNode<?> valueExpr;
        String localVarName;
        Matcher matcher = COMMAND_TEXT_PATTERN.matcher(commandText);
        if (!matcher.matches()) {
            throw new SoySyntaxException("Invalid 'let' command text \"" + commandText + "\".");
        }
        try {
            localVarName = ((VarNode)new ExpressionParser(matcher.group(1)).parseVariable().getChild(0)).getName();
        }
        catch (TokenMgrError tme) {
            throw this.createExceptionForInvalidCommandText("variable name", tme);
        }
        catch (ParseException pe) {
            throw this.createExceptionForInvalidCommandText("variable name", pe);
        }
        if (matcher.group(2) != null) {
            try {
                valueExpr = new ExpressionParser(matcher.group(2)).parseExpression();
            }
            catch (TokenMgrError tme) {
                throw this.createExceptionForInvalidCommandText("value expression", tme);
            }
            catch (ParseException pe) {
                throw this.createExceptionForInvalidCommandText("value expression", pe);
            }
        } else {
            valueExpr = null;
        }
        return Pair.of(localVarName, valueExpr);
    }

    private SoySyntaxException createExceptionForInvalidCommandText(String desc, Throwable cause) {
        return new SoySyntaxException("Invalid " + desc + " in 'let' command text \"" + this.getCommandText() + "\".", cause);
    }

    public String getUniqueVarName() {
        return this.isVarNameUnique ? this.getVarName() : this.getVarName() + "__soy" + this.getId();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }
}

