/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.VarNode;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ForNode
extends AbstractBlockCommandNode
implements SoyNode.StandaloneNode,
SoyNode.StatementNode,
SoyNode.ConditionalBlockNode,
SoyNode.LoopNode,
SoyNode.ExprHolderNode,
SoyNode.LocalVarBlockNode {
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("( [$] \\w+ ) \\s+ in \\s+ range[(] \\s* (.*) \\s* [)]", 36);
    private final String varName;
    private final ImmutableList<String> rangeArgTexts;
    private final ImmutableList<ExprRootNode<?>> rangeArgs;

    public ForNode(int id, String commandText) throws SoySyntaxException {
        super(id, "for", commandText);
        List<ExprRootNode<?>> tempRangeArgs;
        Matcher matcher = COMMAND_TEXT_PATTERN.matcher(commandText);
        if (!matcher.matches()) {
            throw new SoySyntaxException("Invalid 'for' command text \"" + commandText + "\".");
        }
        try {
            this.varName = ((VarNode)new ExpressionParser(matcher.group(1)).parseVariable().getChild(0)).getName();
        }
        catch (TokenMgrError tme) {
            throw this.createExceptionForInvalidCommandText("variable name", tme);
        }
        catch (ParseException pe) {
            throw this.createExceptionForInvalidCommandText("variable name", pe);
        }
        try {
            tempRangeArgs = new ExpressionParser(matcher.group(2)).parseExpressionList();
        }
        catch (TokenMgrError tme) {
            throw this.createExceptionForInvalidCommandText("range specification", tme);
        }
        catch (ParseException pe) {
            throw this.createExceptionForInvalidCommandText("range specification", pe);
        }
        if (tempRangeArgs.size() > 3) {
            throw new SoySyntaxException("Invalid range specification in 'for' command text \"" + commandText + "\".");
        }
        this.rangeArgs = ImmutableList.copyOf(tempRangeArgs);
        ArrayList tempRangeArgTexts = Lists.newArrayList();
        for (ExprRootNode rangeArg : this.rangeArgs) {
            tempRangeArgTexts.add(rangeArg.toSourceString());
        }
        this.rangeArgTexts = ImmutableList.copyOf((Collection)tempRangeArgTexts);
    }

    protected ForNode(ForNode orig) {
        super(orig);
        this.varName = orig.varName;
        this.rangeArgTexts = orig.rangeArgTexts;
        ArrayList tempRangeArgs = Lists.newArrayListWithCapacity((int)orig.rangeArgs.size());
        for (ExprRootNode origRangeArg : orig.rangeArgs) {
            tempRangeArgs.add(origRangeArg.clone());
        }
        this.rangeArgs = ImmutableList.copyOf((Collection)tempRangeArgs);
    }

    private SoySyntaxException createExceptionForInvalidCommandText(String desc, Throwable cause) {
        return new SoySyntaxException("Invalid " + desc + " in 'for' command text \"" + this.getCommandText() + "\".", cause);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.FOR_NODE;
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    public List<String> getRangeArgTexts() {
        return this.rangeArgTexts;
    }

    public List<ExprRootNode<?>> getRangeArgs() {
        return this.rangeArgs;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ExprUnion.createList(this.rangeArgs);
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public ForNode clone() {
        return new ForNode(this);
    }
}

