/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class CssNode
extends AbstractCommandNode
implements SoyNode.StandaloneNode,
SoyNode.StatementNode,
SoyNode.ExprHolderNode {
    @Nullable
    private final ExprRootNode<?> componentNameExpr;
    private final String selectorText;

    public CssNode(int id, String commandText) throws SoySyntaxException {
        super(id, "css", commandText);
        int delimPos = commandText.lastIndexOf(44);
        if (delimPos != -1) {
            String componentNameText = commandText.substring(0, delimPos).trim();
            try {
                this.componentNameExpr = new ExpressionParser(componentNameText).parseExpression();
            }
            catch (TokenMgrError tme) {
                throw new SoySyntaxException("Token error processing " + componentNameText + " in CSS node.");
            }
            catch (ParseException pe) {
                throw new SoySyntaxException("Parse exception processing " + componentNameText + " in CSS node");
            }
            this.selectorText = commandText.substring(delimPos + 1).trim();
        } else {
            this.componentNameExpr = null;
            this.selectorText = commandText;
        }
    }

    protected CssNode(CssNode orig) {
        super(orig);
        this.componentNameExpr = orig.componentNameExpr != null ? orig.componentNameExpr.clone() : null;
        this.selectorText = orig.selectorText;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CSS_NODE;
    }

    public ExprRootNode<?> getComponentNameExpr() {
        return this.componentNameExpr;
    }

    public String getComponentNameText() {
        return this.componentNameExpr != null ? this.componentNameExpr.toSourceString() : null;
    }

    public String getSelectorText() {
        return this.selectorText;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return this.componentNameExpr != null ? ImmutableList.of((Object)new ExprUnion(this.componentNameExpr)) : Collections.emptyList();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public CssNode clone() {
        return new CssNode(this);
    }
}

