/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SoySyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CommandTextAttributesParser {
    private static final Pattern ATTRIBUTE_TEXT = Pattern.compile("([a-z][a-z-]*) = \" ([^\"]*) \" \\s*", 4);
    private final String commandName;
    private final Set<Attribute> supportedAttributes;
    private final Set<String> supportedAttributeNames;

    public CommandTextAttributesParser(String commandName, Attribute ... supportedAttributes) {
        this.commandName = commandName;
        this.supportedAttributes = Sets.newHashSet((Object[])supportedAttributes);
        this.supportedAttributeNames = Sets.newHashSet();
        for (Attribute attribute : supportedAttributes) {
            this.supportedAttributeNames.add(attribute.name);
            if (attribute.allowedValues == Attribute.ALLOW_ALL_VALUES || attribute.defaultValue == "__NDVBR__") continue;
            Preconditions.checkArgument((boolean)attribute.allowedValues.contains(attribute.defaultValue));
        }
    }

    public Map<String, String> parse(String commandText) throws SoySyntaxException {
        HashMap attributes = Maps.newHashMap();
        int i = 0;
        Matcher matcher = ATTRIBUTE_TEXT.matcher(commandText);
        while (matcher.find(i)) {
            if (matcher.start() != i) {
                throw new SoySyntaxException("Malformed attributes in '" + this.commandName + "' command text \"" + commandText + "\".");
            }
            i = matcher.end();
            String name = matcher.group(1);
            String value = matcher.group(2);
            if (!this.supportedAttributeNames.contains(name)) {
                throw new SoySyntaxException("Unsupported attribute '" + name + "' in '" + this.commandName + "' command text \"" + commandText + "\".");
            }
            if (attributes.containsKey(name)) {
                throw new SoySyntaxException("Duplicate attribute '" + name + "' in '" + this.commandName + "' command text \"" + commandText + "\".");
            }
            attributes.put(name, value);
        }
        if (i != commandText.length()) {
            throw new SoySyntaxException("Malformed attributes in '" + this.commandName + "' command text \"" + commandText + "\".");
        }
        for (Attribute supportedAttribute : this.supportedAttributes) {
            if (attributes.containsKey(supportedAttribute.name)) {
                if (supportedAttribute.allowedValues == Attribute.ALLOW_ALL_VALUES || supportedAttribute.allowedValues.contains(attributes.get(supportedAttribute.name))) continue;
                throw new SoySyntaxException("Invalid value for attribute '" + supportedAttribute.name + "' in '" + this.commandName + "' command text \"" + commandText + "\".");
            }
            if ("__NDVBR__".equals(supportedAttribute.defaultValue)) {
                throw new SoySyntaxException("Missing required attribute '" + supportedAttribute.name + "' in '" + this.commandName + "' command text \"" + commandText + "\".");
            }
            attributes.put(supportedAttribute.name, supportedAttribute.defaultValue);
        }
        return attributes;
    }

    public static class Attribute {
        public static final Collection<String> ALLOW_ALL_VALUES = null;
        public static final Collection<String> BOOLEAN_VALUES = ImmutableSet.of((Object)"true", (Object)"false");
        public static final Collection<String> BOOLEAN_VALUES_AND_NULL = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"true", "false", null}));
        public static final String NO_DEFAULT_VALUE_BECAUSE_REQUIRED = "__NDVBR__";
        final String name;
        final Collection<String> allowedValues;
        final String defaultValue;

        public Attribute(String name, Collection<String> allowedValues, String defaultValue) {
            this.name = name;
            this.allowedValues = allowedValues;
            this.defaultValue = defaultValue;
        }
    }
}

