/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.ExprUnion;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class CallParamNode
extends AbstractCommandNode {
    private static final Pattern NONATTRIBUTE_COMMAND_TEXT = Pattern.compile("^ (?! key=\") (\\w+) (?: \\s* : \\s* (\\S .*) )? $", 36);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("param", new CommandTextAttributesParser.Attribute("key", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, "__NDVBR__"), new CommandTextAttributesParser.Attribute("value", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null));

    protected CallParamNode(int id, String commandText) {
        super(id, "param", commandText);
    }

    protected CallParamNode(CallParamNode orig) {
        super(orig);
    }

    protected CommandTextParseResult parseCommandTextHelper(String commandText) throws SoySyntaxException {
        ExprUnion valueExprUnion;
        String valueExprText;
        String key;
        Matcher nctMatcher = NONATTRIBUTE_COMMAND_TEXT.matcher(commandText);
        if (nctMatcher.matches()) {
            key = nctMatcher.group(1);
            valueExprText = nctMatcher.group(2);
        } else {
            Map<String, String> attributes = ATTRIBUTES_PARSER.parse(commandText);
            key = attributes.get("key");
            valueExprText = attributes.get("value");
        }
        try {
            DataRefNode dataRef = (DataRefNode)new ExpressionParser("$" + key).parseDataReference().getChild(0);
            if (dataRef.numChildren() > 1 || dataRef.isIjDataRef()) {
                throw new SoySyntaxException("The key in a 'param' tag must be top level, i.e. not contain multiple keys (invalid 'param' command text \"" + this.getCommandText() + "\").");
            }
        }
        catch (TokenMgrError tme) {
            throw this.createExceptionForInvalidKey(tme);
        }
        catch (ParseException pe) {
            throw this.createExceptionForInvalidKey(pe);
        }
        if (valueExprText != null) {
            ExprRootNode<?> valueExpr;
            try {
                valueExpr = new ExpressionParser(valueExprText).parseExpression();
            }
            catch (TokenMgrError tme) {
                valueExpr = null;
            }
            catch (ParseException pe) {
                valueExpr = null;
            }
            valueExprUnion = valueExpr != null ? new ExprUnion(valueExpr) : new ExprUnion(valueExprText);
        } else {
            valueExprUnion = null;
        }
        return new CommandTextParseResult(key, valueExprUnion);
    }

    private SoySyntaxException createExceptionForInvalidKey(Throwable cause) {
        return new SoySyntaxException("Invalid key in 'param' command text \"" + this.getCommandText() + "\".", cause);
    }

    public abstract String getKey();

    @Override
    public CallNode getParent() {
        return (CallNode)super.getParent();
    }

    protected static class CommandTextParseResult {
        public final String key;
        @Nullable
        public final ExprUnion valueExprUnion;

        private CommandTextParseResult(String key, ExprUnion valueExprUnion) {
            this.key = key;
            this.valueExprUnion = valueExprUnion;
        }
    }
}

