/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public abstract class CallNode
extends AbstractParentCommandNode<CallParamNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<CallParamNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode,
SoyNode.MsgPlaceholderInitialContentNode {
    public static final String FALLBACK_BASE_PLACEHOLDER_NAME = "XXX";
    private final boolean isPassingData;
    private final boolean isPassingAllData;
    @Nullable
    private final ExprRootNode<?> expr;
    @Nullable
    private final String userSuppliedPlaceholderName;

    protected CallNode(int id, String commandName, CommandTextInfo commandTextInfo) {
        super(id, commandName, commandTextInfo.commandText);
        this.isPassingData = commandTextInfo.isPassingData;
        this.isPassingAllData = commandTextInfo.isPassingData && commandTextInfo.exprText == null;
        this.maybeSetSyntaxVersion(commandTextInfo.syntaxVersion);
        if (commandTextInfo.exprText != null) {
            try {
                this.expr = new ExpressionParser(commandTextInfo.exprText).parseExpression();
            }
            catch (TokenMgrError tme) {
                throw this.createExceptionForInvalidExpr(commandTextInfo.commandText, tme);
            }
            catch (ParseException pe) {
                throw this.createExceptionForInvalidExpr(commandTextInfo.commandText, pe);
            }
        } else {
            this.expr = null;
        }
        this.userSuppliedPlaceholderName = commandTextInfo.userSuppliedPlaceholderName;
    }

    private SoySyntaxException createExceptionForInvalidExpr(String commandText, Throwable cause) {
        return new SoySyntaxException("Invalid expression in 'call' command text \"" + commandText + "\".", cause);
    }

    protected static final Pair<Boolean, String> parseDataAttributeHelper(String dataAttr) {
        String exprText;
        boolean isPassingData;
        if (dataAttr == null) {
            isPassingData = false;
            exprText = null;
        } else if (dataAttr.equals("all")) {
            isPassingData = true;
            exprText = null;
        } else {
            isPassingData = true;
            exprText = dataAttr;
        }
        return Pair.of(isPassingData, exprText);
    }

    protected CallNode(CallNode orig) {
        super(orig);
        this.isPassingData = orig.isPassingData;
        this.isPassingAllData = orig.isPassingAllData;
        this.expr = orig.expr != null ? orig.expr.clone() : null;
        this.userSuppliedPlaceholderName = orig.userSuppliedPlaceholderName;
    }

    public boolean isPassingData() {
        return this.isPassingData;
    }

    public boolean isPassingAllData() {
        return this.isPassingAllData;
    }

    public String getExprText() {
        return this.expr != null ? this.expr.toSourceString() : null;
    }

    public ExprRootNode<?> getExpr() {
        return this.expr;
    }

    @Override
    public String getUserSuppliedPlaceholderName() {
        return this.userSuppliedPlaceholderName;
    }

    @Override
    public String getTagString() {
        return this.buildTagStringHelper(this.numChildren() == 0);
    }

    @Override
    public String toSourceString() {
        return this.numChildren() == 0 ? this.getTagString() : super.toSourceString();
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return this.expr != null ? ImmutableList.of((Object)new ExprUnion(this.expr)) : Collections.emptyList();
    }

    @Override
    public String genBasePlaceholderName() {
        if (this.userSuppliedPlaceholderName != null) {
            return BaseUtils.convertToUpperUnderscore(this.userSuppliedPlaceholderName);
        }
        return FALLBACK_BASE_PLACEHOLDER_NAME;
    }

    @Override
    public Object genSamenessKey() {
        return this.getId();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Immutable
    protected static class CommandTextInfo {
        private final String commandText;
        private final boolean isPassingData;
        @Nullable
        private final String exprText;
        @Nullable
        private final String userSuppliedPlaceholderName;
        private final SoyNode.SyntaxVersion syntaxVersion;

        public CommandTextInfo(String commandText, boolean isPassingData, @Nullable String exprText, @Nullable String userSuppliedPlaceholderName, SoyNode.SyntaxVersion syntaxVersion) {
            Preconditions.checkArgument((isPassingData || exprText == null ? 1 : 0) != 0);
            this.commandText = commandText;
            this.isPassingData = isPassingData;
            this.exprText = exprText;
            this.userSuppliedPlaceholderName = userSuppliedPlaceholderName;
            this.syntaxVersion = syntaxVersion;
        }
    }
}

