/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class CallDelegateNode
extends CallNode {
    private static final Pattern NONATTRIBUTE_CALLEE_NAME = Pattern.compile("^ (?! name=\") [.\\w]+ (?= \\s | $)", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("call", new CommandTextAttributesParser.Attribute("name", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("data", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null));
    private final String delCalleeName;

    public CallDelegateNode(int id, String commandTextWithoutPhnameAttr, @Nullable String userSuppliedPlaceholderName) throws SoySyntaxException {
        this(id, CallDelegateNode.parseCommandTextHelper(commandTextWithoutPhnameAttr, userSuppliedPlaceholderName));
    }

    private static final CommandTextInfo parseCommandTextHelper(String commandTextWithoutPhnameAttr, @Nullable String userSuppliedPlaceholderName) {
        Map<String, String> attributes;
        String delCalleeName;
        String commandText = commandTextWithoutPhnameAttr + (userSuppliedPlaceholderName != null ? " phname=\"" + userSuppliedPlaceholderName + "\"" : "");
        Matcher ncnMatcher = NONATTRIBUTE_CALLEE_NAME.matcher(commandTextWithoutPhnameAttr);
        if (ncnMatcher.find()) {
            commandTextWithoutPhnameAttr = ncnMatcher.replaceFirst("name=\"" + ncnMatcher.group() + "\"");
        }
        if ((delCalleeName = (attributes = ATTRIBUTES_PARSER.parse(commandTextWithoutPhnameAttr)).get("name")) == null) {
            throw new SoySyntaxException("The 'delcall' command text must contain the callee name.");
        }
        if (!BaseUtils.isDottedIdentifier(delCalleeName)) {
            throw new SoySyntaxException("Invalid delegate name \"" + delCalleeName + "\" for 'delcall' command.");
        }
        Pair<Boolean, String> dataAttrInfo = CallDelegateNode.parseDataAttributeHelper(attributes.get("data"));
        return new CommandTextInfo(commandText, delCalleeName, (Boolean)dataAttrInfo.first, (String)dataAttrInfo.second, userSuppliedPlaceholderName);
    }

    public CallDelegateNode(int id, String delCalleeName, boolean useAttrStyleForCalleeName, boolean isPassingData, boolean isPassingAllData, @Nullable String exprText, @Nullable String userSuppliedPlaceholderName) {
        this(id, CallDelegateNode.buildCommandTextInfoHelper(delCalleeName, useAttrStyleForCalleeName, isPassingData, isPassingAllData, exprText, userSuppliedPlaceholderName));
    }

    private static final CommandTextInfo buildCommandTextInfoHelper(String delCalleeName, boolean useAttrStyleForCalleeName, boolean isPassingData, boolean isPassingAllData, @Nullable String exprText, @Nullable String userSuppliedPlaceholderName) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(delCalleeName));
        if (isPassingAllData) {
            Preconditions.checkArgument((boolean)isPassingData);
        }
        if (exprText != null) {
            Preconditions.checkArgument((isPassingData && !isPassingAllData ? 1 : 0) != 0);
            Preconditions.checkArgument((!exprText.contains("\"") ? 1 : 0) != 0);
        }
        StringBuilder commandText = new StringBuilder();
        if (useAttrStyleForCalleeName) {
            commandText.append("name=\"").append(delCalleeName).append('\"');
        } else {
            commandText.append(delCalleeName);
        }
        if (isPassingAllData) {
            commandText.append(" data=\"all\"");
        } else if (isPassingData) {
            commandText.append(" data=\"").append(exprText).append('\"');
        }
        if (userSuppliedPlaceholderName != null) {
            commandText.append(" phname=\"").append(userSuppliedPlaceholderName).append('\"');
        }
        return new CommandTextInfo(commandText.toString(), delCalleeName, isPassingData, exprText, userSuppliedPlaceholderName);
    }

    private CallDelegateNode(int id, CommandTextInfo commandTextInfo) {
        super(id, "delcall", commandTextInfo);
        this.delCalleeName = commandTextInfo.delCalleeName;
    }

    protected CallDelegateNode(CallDelegateNode orig) {
        super(orig);
        this.delCalleeName = orig.delCalleeName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_DELEGATE_NODE;
    }

    public String getDelCalleeName() {
        return this.delCalleeName;
    }

    @Override
    public CallDelegateNode clone() {
        return new CallDelegateNode(this);
    }

    @Immutable
    private static class CommandTextInfo
    extends CallNode.CommandTextInfo {
        public final String delCalleeName;

        public CommandTextInfo(String commandText, String delCalleeName, boolean isPassingData, @Nullable String exprText, @Nullable String userSuppliedPlaceholderName) {
            super(commandText, isPassingData, exprText, userSuppliedPlaceholderName, SoyNode.SyntaxVersion.V2);
            Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(delCalleeName));
            this.delCalleeName = delCalleeName;
        }
    }
}

