/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class CallBasicNode
extends CallNode {
    private static final Pattern NONATTRIBUTE_CALLEE_NAME = Pattern.compile("^ (?! name=\" | function=\") [.\\w]+ (?= \\s | $)", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("call", new CommandTextAttributesParser.Attribute("name", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("function", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("data", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null));
    @Nullable
    private String calleeName;
    @Nullable
    private final String partialCalleeName;

    public CallBasicNode(int id, String commandTextWithoutPhnameAttr, @Nullable String userSuppliedPlaceholderName) throws SoySyntaxException {
        this(id, CallBasicNode.parseCommandTextHelper(commandTextWithoutPhnameAttr, userSuppliedPlaceholderName));
    }

    private static final CommandTextInfo parseCommandTextHelper(String commandTextWithoutPhnameAttr, @Nullable String userSuppliedPlaceholderName) {
        String calleeName;
        String partialCalleeName;
        String functionAttribute;
        Map<String, String> attributes;
        String nameAttribute;
        String commandText = commandTextWithoutPhnameAttr + (userSuppliedPlaceholderName != null ? " phname=\"" + userSuppliedPlaceholderName + "\"" : "");
        SoyNode.SyntaxVersion syntaxVersion = SoyNode.SyntaxVersion.V2;
        Matcher ncnMatcher = NONATTRIBUTE_CALLEE_NAME.matcher(commandTextWithoutPhnameAttr);
        if (ncnMatcher.find()) {
            commandTextWithoutPhnameAttr = ncnMatcher.replaceFirst("name=\"" + ncnMatcher.group() + "\"");
        }
        if ((nameAttribute = (attributes = ATTRIBUTES_PARSER.parse(commandTextWithoutPhnameAttr)).get("name")) == null == ((functionAttribute = attributes.get("function")) == null)) {
            throw new SoySyntaxException("The 'call' command text must contain the callee name.");
        }
        if (functionAttribute != null) {
            nameAttribute = functionAttribute;
            syntaxVersion = SoyNode.SyntaxVersion.V1;
        }
        if (BaseUtils.isIdentifierWithLeadingDot(nameAttribute)) {
            partialCalleeName = nameAttribute;
            calleeName = null;
        } else if (BaseUtils.isDottedIdentifier(nameAttribute)) {
            calleeName = nameAttribute;
            partialCalleeName = null;
        } else {
            throw new SoySyntaxException("Invalid callee name \"" + nameAttribute + "\" for 'call' command.");
        }
        Pair<Boolean, String> dataAttrInfo = CallBasicNode.parseDataAttributeHelper(attributes.get("data"));
        return new CommandTextInfo(commandText, calleeName, partialCalleeName, (Boolean)dataAttrInfo.first, (String)dataAttrInfo.second, userSuppliedPlaceholderName, syntaxVersion);
    }

    public CallBasicNode(int id, String calleeName, @Nullable String partialCalleeName, boolean useAttrStyleForCalleeName, boolean isPassingData, boolean isPassingAllData, @Nullable String exprText, @Nullable String userSuppliedPlaceholderName, SoyNode.SyntaxVersion syntaxVersion) {
        this(id, CallBasicNode.buildCommandTextInfoHelper(calleeName, partialCalleeName, useAttrStyleForCalleeName, isPassingData, isPassingAllData, exprText, userSuppliedPlaceholderName, syntaxVersion));
    }

    private static final CommandTextInfo buildCommandTextInfoHelper(String calleeName, @Nullable String partialCalleeName, boolean useAttrStyleForCalleeName, boolean isPassingData, boolean isPassingAllData, @Nullable String exprText, @Nullable String userSuppliedPlaceholderName, SoyNode.SyntaxVersion syntaxVersion) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(calleeName));
        Preconditions.checkArgument((partialCalleeName == null || BaseUtils.isIdentifierWithLeadingDot(partialCalleeName) ? 1 : 0) != 0);
        if (isPassingAllData) {
            Preconditions.checkArgument((boolean)isPassingData);
        }
        if (exprText != null) {
            Preconditions.checkArgument((isPassingData && !isPassingAllData ? 1 : 0) != 0);
            Preconditions.checkArgument((!exprText.contains("\"") ? 1 : 0) != 0);
        }
        StringBuilder commandText = new StringBuilder();
        if (syntaxVersion == SoyNode.SyntaxVersion.V1) {
            commandText.append("function=\"").append(calleeName).append('\"');
        } else {
            String calleeNameInCommandText;
            String string = calleeNameInCommandText = partialCalleeName != null ? partialCalleeName : calleeName;
            if (useAttrStyleForCalleeName) {
                commandText.append("name=\"").append(calleeNameInCommandText).append('\"');
            } else {
                commandText.append(calleeNameInCommandText);
            }
        }
        if (isPassingAllData) {
            commandText.append(" data=\"all\"");
        } else if (isPassingData) {
            commandText.append(" data=\"").append(exprText).append('\"');
        }
        if (userSuppliedPlaceholderName != null) {
            commandText.append(" phname=\"").append(userSuppliedPlaceholderName).append('\"');
        }
        return new CommandTextInfo(commandText.toString(), calleeName, partialCalleeName, isPassingData, exprText, userSuppliedPlaceholderName, syntaxVersion);
    }

    private CallBasicNode(int id, CommandTextInfo commandTextInfo) {
        super(id, "call", commandTextInfo);
        this.calleeName = commandTextInfo.calleeName;
        this.partialCalleeName = commandTextInfo.partialCalleeName;
    }

    protected CallBasicNode(CallBasicNode orig) {
        super(orig);
        this.calleeName = orig.calleeName;
        this.partialCalleeName = orig.partialCalleeName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_BASIC_NODE;
    }

    public void setCalleeName(String calleeName) {
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(calleeName));
        this.calleeName = calleeName;
    }

    public String getCalleeName() {
        return this.calleeName;
    }

    public String getPartialCalleeName() {
        return this.partialCalleeName;
    }

    @Override
    public CallBasicNode clone() {
        return new CallBasicNode(this);
    }

    @Immutable
    protected static class CommandTextInfo
    extends CallNode.CommandTextInfo {
        @Nullable
        private final String calleeName;
        @Nullable
        private final String partialCalleeName;

        public CommandTextInfo(String commandText, @Nullable String calleeName, @Nullable String partialCalleeName, boolean isPassingData, @Nullable String exprText, @Nullable String userSuppliedPlaceholderName, SoyNode.SyntaxVersion syntaxVersion) {
            super(commandText, isPassingData, exprText, userSuppliedPlaceholderName, syntaxVersion);
            Preconditions.checkArgument((calleeName == null || BaseUtils.isDottedIdentifier(calleeName) ? 1 : 0) != 0);
            Preconditions.checkArgument((partialCalleeName == null || BaseUtils.isIdentifierWithLeadingDot(partialCalleeName) ? 1 : 0) != 0);
            Preconditions.checkArgument((calleeName != null || partialCalleeName != null ? 1 : 0) != 0);
            this.calleeName = calleeName;
            this.partialCalleeName = partialCalleeName;
        }
    }
}

