/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public enum AutoescapeMode {
    FALSE,
    TRUE,
    CONTEXTUAL;

    private final String attributeValue = this.name().toLowerCase(Locale.ENGLISH);

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public static Set<String> getAttributeValues() {
        ImmutableSet.Builder values = ImmutableSet.builder();
        for (AutoescapeMode value : AutoescapeMode.values()) {
            values.add((Object)value.getAttributeValue());
        }
        return values.build();
    }

    static Set<String> getAttributeValuesAndNull() {
        HashSet values = Sets.newHashSet(AutoescapeMode.getAttributeValues());
        values.add(null);
        return values;
    }

    public static AutoescapeMode forAttributeValue(String attributeValue) {
        return AutoescapeMode.valueOf(attributeValue.toUpperCase(Locale.ENGLISH));
    }
}

