/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.AbstractNode;
import com.google.template.soy.soytree.SoyNode;

public abstract class AbstractSoyNode
extends AbstractNode
implements SoyNode {
    private int id;
    private SourceLocation location = SourceLocation.UNKNOWN;
    private SoyNode.SyntaxVersion syntaxVersion;

    protected AbstractSoyNode(int id) {
        Preconditions.checkNotNull((Object)id);
        this.id = id;
        this.syntaxVersion = SoyNode.SyntaxVersion.V2;
    }

    protected AbstractSoyNode(AbstractSoyNode orig) {
        super(orig);
        this.id = orig.id;
        this.location = orig.location;
        this.syntaxVersion = orig.syntaxVersion;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public SourceLocation getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(SourceLocation location) {
        if (location == null) {
            throw new NullPointerException();
        }
        this.location = location;
    }

    @Override
    public SoyNode.SyntaxVersion getSyntaxVersion() {
        return this.syntaxVersion;
    }

    protected void maybeSetSyntaxVersion(SoyNode.SyntaxVersion syntaxVersion) {
        if (this.syntaxVersion.compareTo(syntaxVersion) > 0) {
            this.syntaxVersion = syntaxVersion;
        }
    }

    @Override
    public SoyNode.ParentSoyNode<?> getParent() {
        return (SoyNode.ParentSoyNode)super.getParent();
    }

    @Override
    public abstract SoyNode clone();

    @Override
    public String toString() {
        return super.toString() + "_" + this.id;
    }
}

