/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractMsgNode
extends AbstractBlockCommandNode
implements SoyNode.StandaloneNode,
SoyNode.MsgBlockNode {
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("msg", new CommandTextAttributesParser.Attribute("meaning", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("desc", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, "__NDVBR__"), new CommandTextAttributesParser.Attribute("hidden", CommandTextAttributesParser.Attribute.BOOLEAN_VALUES, "false"));
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private final String meaning;
    private final String desc;
    private final boolean isHidden;
    private Map<String, MsgPlaceholderNode> phNameToRepNodeMap = null;
    private Map<MsgPlaceholderNode, String> phNodeToNameMap = null;
    private Map<String, MsgPluralNode> pluralVarNameToRepNodeMap = null;
    private Map<MsgPluralNode, String> pluralNodeToVarNameMap = null;
    private Map<String, MsgSelectNode> selectVarNameToRepNodeMap = null;
    private Map<MsgSelectNode, String> selectNodeToVarNameMap = null;

    public AbstractMsgNode(int id, String commandText) throws SoySyntaxException {
        super(id, "msg", commandText);
        Map<String, String> attributes = ATTRIBUTES_PARSER.parse(commandText);
        this.meaning = attributes.get("meaning");
        this.desc = attributes.get("desc");
        this.isHidden = attributes.get("hidden").equals("true");
    }

    protected AbstractMsgNode(int id, AbstractMsgNode orig) {
        super(id, "msg", orig.getCommandText());
        this.meaning = orig.meaning;
        this.desc = orig.desc;
        this.isHidden = orig.isHidden;
        this.phNameToRepNodeMap = orig.phNameToRepNodeMap != null ? ImmutableMap.copyOf(orig.phNameToRepNodeMap) : null;
        this.phNodeToNameMap = orig.phNodeToNameMap != null ? ImmutableMap.copyOf(orig.phNodeToNameMap) : null;
        this.pluralVarNameToRepNodeMap = orig.pluralVarNameToRepNodeMap != null ? ImmutableMap.copyOf(orig.pluralVarNameToRepNodeMap) : null;
        this.pluralNodeToVarNameMap = orig.pluralNodeToVarNameMap != null ? ImmutableMap.copyOf(orig.pluralNodeToVarNameMap) : null;
        this.selectVarNameToRepNodeMap = orig.selectVarNameToRepNodeMap != null ? ImmutableMap.copyOf(orig.selectVarNameToRepNodeMap) : null;
        this.selectNodeToVarNameMap = orig.selectNodeToVarNameMap != null ? ImmutableMap.copyOf(orig.selectNodeToVarNameMap) : null;
    }

    protected AbstractMsgNode(AbstractMsgNode orig) {
        super(orig);
        this.meaning = orig.meaning;
        this.desc = orig.desc;
        this.isHidden = orig.isHidden;
        this.genPhNamesAndSelectPluralVarsHelper();
    }

    public String getMeaning() {
        return this.meaning;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public String getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    public MsgPlaceholderNode getRepPlaceholderNode(String placeholderName) {
        if (this.phNameToRepNodeMap == null) {
            this.genPhNamesAndSelectPluralVarsHelper();
        }
        return this.phNameToRepNodeMap.get(placeholderName);
    }

    public String getPlaceholderName(MsgPlaceholderNode placeholderNode) {
        if (this.phNodeToNameMap == null) {
            this.genPhNamesAndSelectPluralVarsHelper();
        }
        return this.phNodeToNameMap.get(placeholderNode);
    }

    public MsgPluralNode getRepPluralNode(String pluralVarName) {
        if (this.pluralVarNameToRepNodeMap == null) {
            this.genPhNamesAndSelectPluralVarsHelper();
        }
        return this.pluralVarNameToRepNodeMap.get(pluralVarName);
    }

    public String getPluralVarName(MsgPluralNode pluralNode) {
        if (this.pluralNodeToVarNameMap == null) {
            this.genPhNamesAndSelectPluralVarsHelper();
        }
        return this.pluralNodeToVarNameMap.get(pluralNode);
    }

    public MsgSelectNode getRepSelectNode(String selectVarName) {
        if (this.selectVarNameToRepNodeMap == null) {
            this.genPhNamesAndSelectPluralVarsHelper();
        }
        return this.selectVarNameToRepNodeMap.get(selectVarName);
    }

    public String getSelectVarName(MsgSelectNode selectNode) {
        if (this.selectNodeToVarNameMap == null) {
            this.genPhNamesAndSelectPluralVarsHelper();
        }
        return this.selectNodeToVarNameMap.get(selectNode);
    }

    /*
     * WARNING - void declaration
     */
    protected void genPhNamesAndSelectPluralVarsHelper() {
        HashMap baseNameToRepNodesMap = Maps.newHashMap();
        HashMap nonRepNodeToRepNodeMap = Maps.newHashMap();
        ArrayDeque<SoyNode> traversalQueue = new ArrayDeque<SoyNode>();
        for (SoyNode.StandaloneNode standaloneNode : this.getChildren()) {
            if (!(standaloneNode instanceof MsgPlaceholderNode) && !(standaloneNode instanceof MsgPluralNode) && !(standaloneNode instanceof MsgSelectNode)) continue;
            traversalQueue.add(standaloneNode);
        }
        while (traversalQueue.size() > 0) {
            void var5_10;
            SoyNode node = (SoyNode)traversalQueue.remove();
            if (node instanceof MsgSelectNode) {
                AbstractMsgNode.addGrandchildrenToQueue(traversalQueue, (MsgSelectNode)node);
                String string = AbstractMsgNode.getBaseVarNameFromExpr(((MsgSelectNode)node).getExpr(), "STATUS");
            } else if (node instanceof MsgPluralNode) {
                AbstractMsgNode.addGrandchildrenToQueue(traversalQueue, (MsgPluralNode)node);
                String string = AbstractMsgNode.getBaseVarNameFromExpr(((MsgPluralNode)node).getExpr(), "NUM");
            } else if (node instanceof MsgPlaceholderNode) {
                String string = ((MsgPlaceholderNode)node).genBasePlaceholderName();
            } else {
                throw new AssertionError();
            }
            if (!baseNameToRepNodesMap.containsKey(var5_10)) {
                baseNameToRepNodesMap.put(var5_10, Lists.newArrayList((Object[])new SoyNode[]{node}));
                continue;
            }
            List nodesWithSameBaseName = (List)baseNameToRepNodesMap.get(var5_10);
            boolean isNew = true;
            for (SoyNode other : nodesWithSameBaseName) {
                if (!AbstractMsgNode.isSameAs(node, other)) continue;
                nonRepNodeToRepNodeMap.put(node, other);
                isNew = false;
                break;
            }
            if (!isNew) continue;
            nodesWithSameBaseName.add(node);
        }
        this.phNameToRepNodeMap = Maps.newHashMap();
        this.pluralVarNameToRepNodeMap = Maps.newHashMap();
        this.selectVarNameToRepNodeMap = Maps.newHashMap();
        for (Map.Entry entry : baseNameToRepNodesMap.entrySet()) {
            String baseName = (String)entry.getKey();
            List nodesWithSameBaseName = (List)entry.getValue();
            if (nodesWithSameBaseName.size() == 1) {
                this.updateFinalMapsWithNode(baseName, (SoyNode)nodesWithSameBaseName.get(0));
                continue;
            }
            int nextSuffix = 1;
            for (SoyNode repNode : nodesWithSameBaseName) {
                String newName;
                do {
                    newName = baseName + "_" + nextSuffix;
                    ++nextSuffix;
                } while (baseNameToRepNodesMap.containsKey(newName));
                this.updateFinalMapsWithNode(newName, repNode);
            }
        }
        this.phNodeToNameMap = Maps.newHashMap();
        for (Map.Entry entry : this.phNameToRepNodeMap.entrySet()) {
            this.phNodeToNameMap.put((MsgPlaceholderNode)entry.getValue(), (String)entry.getKey());
        }
        this.selectNodeToVarNameMap = Maps.newHashMap();
        for (Map.Entry entry : this.selectVarNameToRepNodeMap.entrySet()) {
            this.selectNodeToVarNameMap.put((MsgSelectNode)entry.getValue(), (String)entry.getKey());
        }
        this.pluralNodeToVarNameMap = Maps.newHashMap();
        for (Map.Entry entry : this.pluralVarNameToRepNodeMap.entrySet()) {
            this.pluralNodeToVarNameMap.put((MsgPluralNode)entry.getValue(), (String)entry.getKey());
        }
        for (Map.Entry entry : nonRepNodeToRepNodeMap.entrySet()) {
            SoyNode nonRepNode = (SoyNode)entry.getKey();
            SoyNode repNode = (SoyNode)entry.getValue();
            if (nonRepNode instanceof MsgPlaceholderNode) {
                this.phNodeToNameMap.put((MsgPlaceholderNode)nonRepNode, this.phNodeToNameMap.get(repNode));
                continue;
            }
            if (nonRepNode instanceof MsgSelectNode) {
                this.selectNodeToVarNameMap.put((MsgSelectNode)nonRepNode, this.selectNodeToVarNameMap.get(repNode));
                continue;
            }
            if (!(nonRepNode instanceof MsgPluralNode)) continue;
            this.pluralNodeToVarNameMap.put((MsgPluralNode)nonRepNode, this.pluralNodeToVarNameMap.get(repNode));
        }
    }

    private static void addGrandchildrenToQueue(Deque<SoyNode> traversalQueue, SoyNode.ParentSoyNode<CaseOrDefaultNode> selectOrPluralNode) {
        for (CaseOrDefaultNode child : selectOrPluralNode.getChildren()) {
            for (SoyNode.StandaloneNode grandchild : child.getChildren()) {
                if (!(grandchild instanceof MsgPlaceholderNode) && !(grandchild instanceof MsgPluralNode) && !(grandchild instanceof MsgSelectNode)) continue;
                traversalQueue.add(grandchild);
            }
        }
    }

    private void updateFinalMapsWithNode(String baseName, SoyNode node) {
        if (node instanceof MsgPlaceholderNode) {
            this.phNameToRepNodeMap.put(baseName, (MsgPlaceholderNode)node);
        } else if (node instanceof MsgSelectNode) {
            this.selectVarNameToRepNodeMap.put(baseName, (MsgSelectNode)node);
        } else if (node instanceof MsgPluralNode) {
            this.pluralVarNameToRepNodeMap.put(baseName, (MsgPluralNode)node);
        }
    }

    private static boolean isSameAs(SoyNode node, SoyNode otherNode) {
        if (node instanceof MsgPlaceholderNode && otherNode instanceof MsgPlaceholderNode) {
            return ((MsgPlaceholderNode)node).isSamePlaceholderAs((MsgPlaceholderNode)otherNode);
        }
        if (node instanceof MsgPluralNode && otherNode instanceof MsgPluralNode) {
            return ((MsgPluralNode)node).getCommandText().equals(((MsgPluralNode)otherNode).getCommandText());
        }
        if (node instanceof MsgSelectNode && otherNode instanceof MsgSelectNode) {
            return ((MsgSelectNode)node).getCommandText().equals(((MsgSelectNode)otherNode).getCommandText());
        }
        return false;
    }

    public static String getBaseVarNameFromExpr(ExprRootNode<?> exprRoot, String fallbackBaseName) {
        Node expr = exprRoot.getChild(0);
        if (expr instanceof DataRefNode) {
            DataRefNode dataRefNode = (DataRefNode)expr;
            ExprNode lastPart = dataRefNode.getChild(dataRefNode.numChildren() - 1);
            if (lastPart instanceof DataRefKeyNode) {
                return BaseUtils.convertToUpperUnderscore(((DataRefKeyNode)lastPart).getKey());
            }
        } else if (expr instanceof GlobalNode) {
            GlobalNode globalNode = (GlobalNode)expr;
            int lastDotIndex = globalNode.getName().lastIndexOf(46);
            String lastPart = globalNode.getName().substring(lastDotIndex + 1);
            return BaseUtils.convertToUpperUnderscore(lastPart);
        }
        return fallbackBaseName;
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }
}

